% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-export.r
\name{readOpenxlsx}
\alias{readOpenxlsx}
\title{Import one or more data.frame from 'Excel' 'xlsx' format}
\usage{
readOpenxlsx(
  xlsx,
  sheet = NULL,
  startRow = 1,
  startCol = 1,
  rows = NULL,
  cols = NULL,
  check.names = FALSE,
  check_header = FALSE,
  check_header_n = 10,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{xlsx}{\code{character} path to an 'Excel' file in \code{xlsx} format,
compatible with \code{openxlsx::read.xlsx()}.}

\item{sheet}{one of \code{NULL}, \code{character}, or \code{integer} vector,
where: \code{sheet=NULL} will import every sheet; \code{character} is
a vector of sheet names; and \code{integer} is a vector of sheet
index values. The sheet names are determined with
\code{openxlsx::getSheetNames()}.}

\item{startRow}{\code{integer} indicating the row number to start
importing each \code{sheet}.
\itemize{
\item Note \code{startRow} can be a vector
with length \code{length(sheet)}, to specify the \code{startRow} for
each \code{sheet}.
\item Note \code{startRow} is ignored when \code{rows} is defined for the same sheet,
to minimize confusion about using both togetheer.
}}

\item{startCol}{\code{integer} indicating the first column number to retain
after importing each \code{sheet}.
\itemize{
\item Note \code{startCol} can be a vector with length \code{length(sheet)},
to specify the \code{startCol} for each \code{sheet}.
\item Note \code{startCol} is ignored when \code{cols} is defined for the same sheet,
to minimize confusion about using both togetheer.
}}

\item{rows}{\code{integer} vector indicating specific rows to import
for each \code{sheet}.
\itemize{
\item To specify different \code{rows} for each \code{sheet},
supply \code{rows} as a \code{list} of \code{integer} vectors.
\item Note that when \code{rows} is defined for a sheet, it will be used
and \code{startRow} will be ignored for that same sheet.
}}

\item{cols}{\code{integer} vector indicating specific column numbers to import
for each \code{sheet}.
\itemize{
\item To specify different \code{cols} for each \code{sheet}, supply \code{cols}
as a \code{list} of \code{integer} vectors.
\item Note that when \code{cols} is defined for a sheet, it will be used
and \code{startCol} will be ignored for that same sheet.
}}

\item{check.names}{\code{logical} indicating whether to call \code{make.names()}
on the \code{colnames} of each \code{data.frame}.
\itemize{
\item Note that \code{openxlsx::read.xlsx()} does not honor \code{check.names=FALSE},
so a workaround is applied which loads a single line
without column headers, in order to obtain the same data without
mangling column headers. If this process fails, another workaround
is to use \code{startRow=2} (one higher than previous) and \code{colNames=FALSE}.
}}

\item{check_header}{\code{logical} indicating whether to test for presence
of header rows, which may be multi-line column headers.
When \code{check_header=TRUE}, this
method simply tests for the presence of rows that have \code{ncol}
different than the remaining rows of data in the given sheet.
When header rows are detected, the values are assigned to column
\code{dimnames} of the \code{data.frame}.}

\item{check_header_n}{\code{integer} number of rows to test for header rows,
only used when \code{check_header=TRUE}. This step is intended when
the top row(s) contain fewer columns with headers, above actual
column headers, for example the first row \code{c("Sample", "", "", "Lane", "")},
and the second row \code{c("Name", "Type", "Label", "Name", "Type")}.
In this case the desired output is
\verb{"Sample_Name","Sample_Type","Sample_Label","Lane_Name","Lane_Type")}.
This option default is \code{FALSE} due to the number of exceptions
seen in real data.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional arguments are passed to \code{openxlsx::read.xlsx()}.}
}
\value{
\code{list} of \code{data.frame} objects, one per sheet in \code{xlsx}.
}
\description{
Import one or more data.frame from 'Excel' 'xlsx' format
}
\details{
This function is equivalent to \code{openxlsx::read.xlsx()}
with a few minor additions:
\enumerate{
\item It returns a \code{list} of \code{data.frame} objects, one per \code{sheet}.
\item It properly reads the \code{colnames} with \code{check.names=FALSE}.
}

By default this function returns every \code{sheet} for a given
\code{xlsx} file.

Some useful details:
\itemize{
\item Empty columns are not skipped during loading, which means a worksheet
whose data starts at column 3 will be returned with two empty columns,
followed by data from that worksheet. Similarly, any empty columns
in the middle of the data in that worksheet will be included in the
output.
\item When both \code{startRow} and \code{rows} are applied, \code{rows} takes priority
and will be used instead of \code{startRows}. In fact \code{startRows} will be
defined \code{startRows <- min(rows)} for each relevant worksheet. However,
for each worksheet either argument can be \code{NULL}.
}
}
\examples{
# set up a test data.frame
set.seed(123);
lfc <- -3:3 + stats::rnorm(7)/3;
colorSub <- nameVector(
   rainbow2(7),
   LETTERS[1:7])
df <- data.frame(name=LETTERS[1:7],
   int=round(4^(1:7)),
   num=(1:7)*4-2 + stats::rnorm(7),
   fold=2^abs(lfc)*sign(lfc),
   lfc=lfc,
   pvalue=10^(-1:-7 + stats::rnorm(7)),
   hit=sample(c(-1,0,0,1,1), replace=TRUE, size=7));
df;
# write to tempfile for examples
if (check_pkg_installed("openxlsx")) {
   out_xlsx <- tempfile(pattern="writeOpenxlsx_", fileext=".xlsx")
   writeOpenxlsx(x=df,
      file=out_xlsx,
      sheetName="jamba_test",
      append=FALSE);
   # now read it back
   df_list <- readOpenxlsx(xlsx=out_xlsx);
   df_list[[1]]
}

}
\seealso{
Other jam export functions: 
\code{\link{applyXlsxCategoricalFormat}()},
\code{\link{applyXlsxConditionalFormat}()},
\code{\link{set_xlsx_colwidths}()},
\code{\link{set_xlsx_rowheights}()},
\code{\link{writeOpenxlsx}()}
}
\concept{jam export functions}
