% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{heads}
\alias{heads}
\title{Apply head() across each element in a list of vectors}
\usage{
heads(x, n = 6, ...)
}
\arguments{
\item{x}{\code{list} of atomic vectors, assumed to be the same
atomic type.}

\item{n}{\code{integer} maximum number of items to include from
each element in the list \code{x}. When \code{n} contains multiple
values, they are recycled to \code{length(x)} and applied to each
list element in order.}

\item{...}{additional arguments are passed to \code{utils::head()}.}
}
\value{
\code{list} with at most \code{n} elements per vector.
}
\description{
Apply head() across each element in a list of vectors
}
\details{
Note that this function currently only operates on a list
of vectors. This function is notably faster than
\code{lapply(x, head, n)} because it operates on the entire
vector in one step.

Also the input \code{n} can be a vector so that each element in
the list has a specific number of items returned.
}
\examples{
l <- list(a=1:10, b=2:5, c=NULL, d=1:100);
heads(l, 1);

heads(l, 2);

heads(l, n=c(2, 1, 3, 5))

}
\seealso{
Other jam list functions: 
\code{\link{cPaste}()},
\code{\link{jam_rapply}()},
\code{\link{list2df}()},
\code{\link{mergeAllXY}()},
\code{\link{mixedSorts}()},
\code{\link{rbindList}()},
\code{\link{relist_named}()},
\code{\link{rlengths}()},
\code{\link{sclass}()},
\code{\link{sdim}()},
\code{\link{uniques}()},
\code{\link{unnestList}()}
}
\concept{jam list functions}
