% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_typeIerror_Simes_mvtnorm.R
\name{typeIerror_Simes_mvtnorm}
\alias{typeIerror_Simes_mvtnorm}
\title{Calculate the type I error rate of the weighted Simes test}
\usage{
typeIerror_Simes_mvtnorm(
  rho,
  adjFct = 0,
  alpha,
  alphavec = c(alpha/2, alpha/2)
)
}
\arguments{
\item{rho}{the correlation coefficient between two test statistics}

\item{adjFct}{a pre-specified constant in the improved weighted Hochberg procedure, called the adjustment factor or k value}

\item{alpha}{the significance level}

\item{alphavec}{a numeric vector of two values representing the weighted significance levels assigned to the two hypotheses}
}
\value{
the type I error rate
}
\description{
Calculate the type I error rate of the weighted Simes test
}
\examples{
typeIerror_trimSimes_mvtnorm(rho = 0, adjFct = 0, alpha = 0.05)
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou
}
