% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_optrho.R
\name{optrho}
\alias{optrho}
\title{Calculate the rho value that reaches the maximum type I error rate in the improved trimmed Hochberg method when k value is given}
\usage{
optrho(k, alpha, alphavec = c(alpha/2, alpha/2))
}
\arguments{
\item{k}{a pre-specified constant in the improved trimmed weighted Hochberg procedure}

\item{alpha}{the significance level}

\item{alphavec}{a numeric vector of two values representing the weighted significance levels assigned to the two hypotheses}
}
\value{
the rho value that makes the type I error rate reaches the maximum value \code{rho_opt} and the type I error rate \code{errorrate}
}
\description{
Calculate the rho value that reaches the maximum type I error rate in the improved trimmed Hochberg method when k value is given
}
\examples{
optrho(k = 2/3, alpha = 0.025)
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
