% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_find_rho_target_mvtnorm.R
\name{find_rho_target_mvtnorm}
\alias{find_rho_target_mvtnorm}
\title{Find the partial derivative of the error rate with respect to the correlation coefficient rho when k and rho are given}
\usage{
find_rho_target_mvtnorm(rho, k, alpha, alphavec = c(alpha/2, alpha/2))
}
\arguments{
\item{rho}{the correlation coefficient between two test statistics}

\item{k}{a pre-specified constant in the improved trimmed weighted Hochberg procedure}

\item{alpha}{the significance level}

\item{alphavec}{a numeric vector of two values representing the weighted significance levels assigned to the two hypotheses}
}
\value{
the partial derivative of the error rate with respect to the correlation coefficient rho
}
\description{
Find the partial derivative of the error rate with respect to the correlation coefficient rho when k and rho are given
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou
}
