% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{orbi_plot_spectra}
\alias{orbi_plot_spectra}
\title{Plot mass spectra}
\usage{
orbi_plot_spectra(
  aggregated_data,
  mz_min = 0,
  mz_max = Inf,
  mz_base_peak = NULL,
  mz_focus_nominal_offsets = 0:4,
  max_scans = 6,
  max_files = 4,
  label_peaks = TRUE,
  show_filenames = TRUE,
  show_ref_and_lock_peaks = TRUE,
  show_focus_backgrounds = TRUE,
  background_colors = c("#1B9E77", "#D95F02", "#7570B3", "#E7298A", "#66A61E", "#E6AB02",
    "#A6761D", "#666666", "#BBBBBB")
)
}
\arguments{
\item{aggregated_data}{data aggregated by \code{\link[=orbi_aggregate_raw]{orbi_aggregate_raw()}} and, optionally, with isotopocules already identified by \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}}, and (also optionally), alreadty filtered with \code{\link[=orbi_filter_isotopocules]{orbi_filter_isotopocules()}}}

\item{mz_min}{which mz to start the main plot window at. By default include all.}

\item{mz_max}{which mz to end the main plot window at. By default include all.}

\item{mz_base_peak}{where is the base peak at (approximately)?. If not specified (the default), takes the largest peak in the \code{mz_min} to \code{mz_max} window.}

\item{mz_focus_nominal_offsets}{which panels to visualize? 0 = whole spectrum, 1 = spectrum around monoisotopic peak + 1 mu (M+1), 2 = M+2, etc.
By default includes the whole spectrum and up to +1, +2, +3, and +4 peaks (if they exist).
To visualize only the whole spectrum, use \code{mz_focus_nominal_offsets = 0}.
Likewise, to visualize only the area around the monoisotopic peak +1, provide \code{mz_focus_monimal_offsets = 1} (or \verb{= c(1, 2)} for both +1 and +2 windows).}

\item{max_scans}{spectra from how many scans to show at most. By default up to 6 (the number of available linetypes). To show only the spectrum from a single scan, set \code{max_scans = 1}. If more than 6 scan spectra are allowed (and there are more than 6 loaded in the \code{aggregated_data}), turns of the linetype aesthetic.}

\item{max_files}{spectra from how many files to show at most. Each file is shown as an additional line of panels.}

\item{label_peaks}{whether to label the peaks in the M+1/2/3 panels. If isotopcules are already identified from \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}}, uses the isotopcule names, otherwise the m/z values. Peaks that are missing (identified by \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}}) in all spectra are highlighted in red.
To avoid labeling unidentified/missing peaks, run \code{\link[=orbi_filter_isotopocules]{orbi_filter_isotopocules()}} first.}

\item{show_filenames}{whether to show the filename in the first panel of reach row (usually the full spectrum panel)}

\item{show_ref_and_lock_peaks}{whether to show reference and lock mass peaks in the spectrum}

\item{show_focus_backgrounds}{whether to highlight the M+x panels with specific background colors that match them with the mass bands highlighted in the first panel}

\item{background_colors}{the colors to use for the background highlighting}
}
\description{
This function visualizes mass spectra from aggregated raw file data.
The spectra have to be be previously read in with \code{include_spectra = c(1, 10, 100)} in \code{\link[=orbi_read_raw]{orbi_read_raw()}}.
By default, this function tries to visualize different isotopcule ranges (monoisotopic peak, M+1, M+2, M+3).
To focus only on isotopcules of interest, run \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} and \code{\link[=orbi_filter_isotopocules]{orbi_filter_isotopocules()}} first.
}
