% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso8601todate.R
\name{iso8601todate}
\alias{iso8601todate}
\title{Convert date in ISO8601 format into R Date object}
\usage{
iso8601todate(x, ndigitsyear = 4L)
}
\arguments{
\item{x}{character vector of ISO8601 date string. When the string also
contains a time part, this is ignored.}

\item{ndigitsyear}{Number of digits used to encode the year. This should be
an integer with values >= 4 with the same length as \code{x} or length one.
When it is a vector with length greater than one, a different value is used
for each element of \code{x}.}
}
\value{
Returns a \code{\link{Date}} object with the same length as \code{x}.
}
\description{
Convert date in ISO8601 format into R Date object
}
\details{
Dates are accepted in any of the formats supported by ISO8601.
}
\examples{
iso8601todate(c("2024-01-01", "2024-W01-1", "2024001", 
  "2024-01-01T12:30"))

iso8601todate("2019-08-17")
iso8601todate("2019-08")
iso8601todate("2019")
iso8601todate("20190817")
iso8601todate("2019-W33-6")
iso8601todate("2019-W33")
iso8601todate("2019W336")
iso8601todate("2019W33")
iso8601todate("2019-229")
iso8601todate("2019229")
iso8601todate("\u22120009-123")
iso8601todate("-0009")
iso8601todate("+002019-229", ndigitsyear = 6)

}
