% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{add_to_extract_micro}
\alias{add_to_extract_micro}
\alias{add_to_extract.micro_extract}
\title{Add values to an existing extract definition for an IPUMS microdata
collection}
\usage{
\method{add_to_extract}{micro_extract}(
  extract,
  description = NULL,
  samples = NULL,
  variables = NULL,
  time_use_variables = NULL,
  sample_members = NULL,
  data_format = NULL,
  data_structure = NULL,
  rectangular_on = NULL,
  case_select_who = NULL,
  data_quality_flags = NULL,
  ...
)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{description}{Description of the extract.}

\item{samples}{Vector of samples to include in the extract
request. Use \code{\link[=get_sample_info]{get_sample_info()}} to identify
sample IDs for a given collection.}

\item{variables}{Character vector of variable names or a list of
\code{var_spec} objects created by \code{\link[=var_spec]{var_spec()}}
containing specifications for all variables to include in the extract.

If a variable already exists in the extract, its specifications
will be added to those that already exist for that variable.}

\item{time_use_variables}{Vector of names of IPUMS-defined time use variables
or a list of specifications for user-defined time use variables
to include in the extract request. Use \code{\link[=tu_var_spec]{tu_var_spec()}} to create a
\code{tu_var_spec} object containing a time use variable specification.}

\item{sample_members}{Indication of whether to include additional sample
members in the extract request. If provided, must be one of
\code{"include_non_respondents"}, \code{"include_household_members"}, or both.

Sample member selection is only available for the IPUMS ATUS collection
(\code{"atus"}).}

\item{data_format}{Format for the output extract data file. Either
\code{"fixed_width"} or \code{"csv"}.

Note that while \code{"stata"}, \code{"spss"}, or \code{"sas9"} are also accepted, these
file formats are not supported by ipumsr data-reading functions.}

\item{data_structure}{Data structure for the output extract data.
\itemize{
\item \code{"rectangular"} provides data in which every row has the same record type
(determined by \code{"rectangular_on"}), with variables from other record types
written onto associated records of the chosen type (e.g. household
variables written onto person records).
\item \code{"hierarchical"} provides data that include rows of differing record
types, with records ordered according to their hierarchical structure (e.g.
each person record is followed by the activity records for that person).
\item \code{"household_only"} provides household records only. This data structure
is only available for the IPUMS USA collection (\code{"usa"}).
}}

\item{rectangular_on}{If \code{data_structure} is \code{"rectangular"},
records on which to rectangularize. One of \code{"P"} (person), \code{"A"}
(activity), \code{"I"} (injury) or \code{"R"} (round).

Defaults to \code{"P"} if \code{data_structure} is \code{"rectangular"} and \code{NULL}
otherwise.}

\item{case_select_who}{Indication of how to interpret any case selections
included for variables in the extract definition.
\itemize{
\item \code{"individuals"} includes records for all individuals who match the
specified case selections.
\item \code{"households"} includes records for all members of each household that
contains an individual who matches the specified case selections.
}

Defaults to \code{"individuals"}. Use \code{\link[=var_spec]{var_spec()}} to add case selections for
specific variables.}

\item{data_quality_flags}{Set to \code{TRUE} to include data quality
flags for all applicable variables in the extract definition. This will
override the \code{data_quality_flags} specification for individual variables
in the definition.

Use \code{\link[=var_spec]{var_spec()}} to add data quality flags for specific variables.}

\item{...}{Ignored}
}
\value{
A modified \code{micro_extract} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Add new values or replace existing values in an IPUMS microdata extract
definition. All fields are optional, and if omitted, will be unchanged.
Supplying a value
for fields that take a single value, such as \code{description} and \code{data_format},
will replace the existing value with the supplied value.

This function is marked as experimental because it is typically not the best
option for maintaining reproducible extract definitions and may be retired
in the future. For reproducibility, users should strive to build extract
definitions with \code{\link[=define_extract_micro]{define_extract_micro()}}.

If you have a complicated extract definition to revise, but do not have
the original extract definition code that created it, we suggest that you
save the revised extract as a JSON file with \code{\link[=save_extract_as_json]{save_extract_as_json()}}. This
will create a stable version of the extract definition that
can be used in the future as needed.

To remove existing values from an IPUMS microdata extract definition, use
\code{\link[=remove_from_extract.micro_extract]{remove_from_extract()}}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\details{
If the supplied extract definition comes from
a previously submitted extract request, this function will reset the
definition to an unsubmitted state.

To modify variable-specific parameters for variables that already exist
in the extract, create a new variable specification with \code{\link[=var_spec]{var_spec()}}.
}
\examples{
extract <- define_extract_micro(
  collection = "usa",
  description = "2013 ACS Data",
  samples = "us2013a",
  variables = c("SEX", "AGE", "YEAR")
)

# Add a single sample
add_to_extract(extract, samples = "us2014a")

# Add samples and variables
extract2 <- add_to_extract(
  extract,
  samples = "us2014a",
  variables = c("MARST", "BIRTHYR")
)

# Modify specifications for variables in the extract by using `var_spec()`
# with the existing variable name:
add_to_extract(
  extract,
  samples = "us2014a",
  variables = var_spec("SEX", case_selections = "2")
)

# You can make multiple modifications or additions by providing a list
# of `var_spec()` objects:
add_to_extract(
  extract,
  samples = "us2014a",
  variables = list(
    var_spec("RACE", attached_characteristics = "mother"),
    var_spec("SEX", case_selections = "2"),
    var_spec("RELATE")
  )
)

# Values that only take a single value are replaced
add_to_extract(extract, description = "New description")$description
}
\seealso{
\code{\link[=remove_from_extract.micro_extract]{remove_from_extract()}} to remove
values from an extract definition.

\code{\link[=submit_extract]{submit_extract()}} to submit an extract request.

\code{\link[=download_extract]{download_extract()}} to download extract data files.

\code{\link[=define_extract_micro]{define_extract_micro()}} to create a new extract
definition from scratch
}
\keyword{internal}
