% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_filters.R
\name{repFilter}
\alias{repFilter}
\alias{include}
\alias{exclude}
\alias{lessthan}
\alias{morethan}
\alias{interval}
\title{Main function for data filtering}
\usage{
repFilter(
  .data,
  .method = "by.clonotype",
  .query = list(CDR3.aa = exclude("partial", "out_of_frame")),
  .match = "exact"
)
}
\arguments{
\item{.data}{The data to be processed. Must be the list of 2 elements:
a data table and a metadata table.}

\item{.method}{Method of filtering. Implemented methods:
by.meta, by.repertoire (by.rep), by.clonotype (by.cl)
Default value: 'by.clonotype'.}

\item{.query}{Filtering query. It's a named list of filters that will be applied
to data.
Possible values for names in this list are dependent on filter methods:
\itemize{
\item by.meta: filters by metadata. Names in the named list are metadata column headers.
\item by.repertoire: filters by the number of clonotypes or total number of clones in sample.
Possible names in the named list are "n_clonotypes" and "n_clones".
\item by.clonotype: filters by data in all samples. Names in the named list are
data column headers.
Elements of the named list for each of the filters are filtering options.
Possible values for filtering options:
\item include("STR1", "STR2", ...): keeps only rows with matching values.
Available for methods: "by.meta", "by.clonotype".
\item exclude("STR1", "STR2", ...): removes rows with matching values.
Available for methods: "by.meta", "by.clonotype".
\item lessthan(value): keeps rows/samples with numeric values less than specified.
Available for methods: "by.meta", "by.repertoire", "by.clonotype".
\item morethan(value): keeps rows/samples with numeric values more than specified.
Available for methods: "by.meta", "by.repertoire", "by.clonotype".
\item interval(from, to): keeps rows/samples with numeric values that fits in this interval.
from is inclusive, to is exclusive.
Available for methods: "by.meta", "by.repertoire", "by.clonotype".
Default value: 'list(CDR3.aa = exclude("partial", "out_of_frame"))'.
}}

\item{.match}{Matching method for "include" and "exclude" options in query.
Possible values:
\itemize{
\item exact: matches only the exact specified string;
\item startswith: matches all strings starting with the specified substring;
\item substring: matches all strings containing the specified substring.
Default value: 'exact'.
}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\concept{filters}
