// [[Rcpp::depends(RcppArmadillo)]]


#include <RcppArmadillo.h>
using namespace Rcpp;

// [[Rcpp::export]]
double modS_one(double x1, double s11, int df1, double x2, double s22, int df2,
                 double upLim = .5, double x10 = 0, double x20 = 0, double s12 = 0){
  // upLim is a percentage as specified by the user.

  upLim = std::min(upLim, 1.0) / 2.0;

  // Test and correction if variables are not independent.
  // This occurs with missing data and EM algorithm implemented in the mmed package;
  if(s12 != 0){
    arma::mat tempCM = arma::zeros(2, 2);
    tempCM(0, 0) = s11;
    tempCM(1, 1) = s22;
    tempCM(0, 1) = s12; tempCM(1, 0) = s12;
    arma::mat cholM = chol(tempCM, "lower");
    arma::mat decomp = arma::inv(cholM);

    arma::vec tempMeans = arma::zeros(2);
    arma::vec tempNull = arma::zeros(2);
    tempMeans(0) = x1; tempMeans(1) = x2;
    tempNull(0) = x10; tempNull(1) = x20;

    arma::vec newMeans = decomp * tempMeans;
    arma::vec newNull = decomp * tempNull;

    x1 = newMeans(0); x2 = newMeans(1);
    x10 = newNull(0); x20 = newNull(1);
    s11 = 1; s22 = 1;
  }

  double z1 = (x1 - x10) / std::sqrt(s11);
  double z2 = (x2 - x20) / std::sqrt(s22);
  double U1 = R::pt(fabs(z1), df1, 1, 0 );
  double U2 = R::pt(fabs(z2), df2, 1, 0 );
  //double U1 = R::pnorm(z1, 0.0, 1.0, 1, 0);
  //double U2 = R::pnorm(z2, 0.0, 1.0, 1, 0);
  U1 = std::min(U1, 1.0 - U1);
  U2 = std::min(U2, 1.0 - U2);

  double cornerP = std::max(U1, U2)*2;

  double bandP = (std::fabs(U1 - U2) * 4.0);

  //upLim = std::min(upLim, 0.5 - bandP/4.0);

  if(U2 >= - U1 + upLim*2 || (U1 < bandP/2.0)*1 + (U2 < bandP/2.0)*1 == 1){bandP = 1.0;}

  return std::min(bandP, cornerP);
}


/* Wrapper function to call modS - modS was the original name and was changed to ps;*/


// [[Rcpp::export]]
double ps_one_old(double x1, double s11, int df1, double x2, double s22, int df2,
              double upLim = .5, double x10 = 0, double x20 = 0, double s12 = 0){
  return modS_one(x1, s11, df1, x2, s22, df2, upLim, x10, x20, s12);
}

/*
 double modS_one(double x1, double s11, int df1, double x2, double s22, int df2,
                 double upLim = .5, double x10 = 0, double x20 = 0, double s12 = 0){
   // upLim is a percentage as specified by the user.

   upLim = std::min(upLim, 1.0) / 2.0;

   // Test and correction if variables are not independent.
   // This occurs with missing data and EM algorithm implimented in the mmed package;
   if(s12 != 0){
     arma::mat tempCM = arma::zeros(2, 2);
     tempCM(0, 0) = s11;
     tempCM(1, 1) = s22;
     tempCM(0, 1) = s12; tempCM(1, 0) = s12;
     arma::mat cholM = chol(tempCM, "lower");
     arma::mat decomp = arma::inv(cholM);

     arma::vec tempMeans = arma::zeros(2);
     arma::vec tempNull = arma::zeros(2);
     tempMeans(0) = x1; tempMeans(1) = x2;
     tempNull(0) = x10; tempNull(1) = x20;

     arma::vec newMeans = decomp * tempMeans;
     arma::vec newNull = decomp * tempNull;

     x1 = newMeans(0); x2 = newMeans(1);
     x10 = newNull(0); x20 = newNull(1);
     s11 = 1; s22 = 1;
   }

   double z1 = (x1 - x10) / std::sqrt(s11);
   double z2 = (x2 - x20) / std::sqrt(s22);
   double U1 = R::pt(fabs(z1), df1, 1, 0 );
   double U2 = R::pt(fabs(z2), df2, 1, 0 );
   //double U1 = R::pnorm(z1, 0.0, 1.0, 1, 0);
   //double U2 = R::pnorm(z2, 0.0, 1.0, 1, 0);
   U1 = std::min(U1, 1.0 - U1);
   U2 = std::min(U2, 1.0 - U2);

   double cornerP = std::max(U1, U2)*2;

   double bandP = (std::fabs(U1 - U2) * 4.0);

   //upLim = std::min(upLim, 0.5 - bandP/8.0); // Division by 8 to adjust for middle of the bar;

   if(U2 >= - U1 + upLim + .5 || (U1 < bandP/2.0)*1 + (U2 < bandP/2.0)*1 == 1){bandP = 1.0;}

   return std::min(bandP, cornerP);
 }

 */
