% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_functions.R
\name{AsubsetB}
\alias{AsubsetB}
\title{Check if closed interval is contained in other closed interval}
\usage{
AsubsetB(A, B, B.left.open = FALSE, B.right.open = FALSE)
}
\arguments{
\item{A}{Two column matrix containing intervals to be checked for being 
contained in B}

\item{B}{Two column matrix containing intervals possibly overlapping 
the intervals in A}

\item{B.left.open}{Are the intervals in B left-open?}

\item{B.right.open}{Are the intervals in B right-open?}
}
\value{
Matrix of size (nrow(A) * nrow(B)) with binary values indicating 
whether the intervals in A are contained in B
}
\description{
Function which takes as input two matrices with 2 columns each 
and checks whether each interval in the first matrix is contained within 
each interval in the second matrix.
}
