% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation.R
\name{case_II_X}
\alias{case_II_X}
\title{Construct Case II Interval Censoring Data}
\usage{
case_II_X(event_times, survey_times)
}
\arguments{
\item{event_times}{A numeric vector of event times for each individual.}

\item{survey_times}{A numeric matrix with two columns, where each row contains the left and right
censoring (survey) times for each individual.}
}
\value{
A matrix with two columns, where each row represents an individual's interval-censored data.
        The first column is the left endpoint, and the second column is the right endpoint.
        If the event time is before the left survey time, the interval is \code{(0, left survey time]}.
        If the event time is after the right survey time, the interval is \code{(right survey time, Inf)}.
        If the event time falls between the left and right survey times, the interval is \code{(left survey time, right survey time]}.
}
\description{
This function constructs case II interval-censored data using the provided event times and censoring (survey) times.
Each individual's event time is either left-censored, right-censored, or interval-censored
based on two survey times: the left and right bounds of the interval.
}
