% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_rblood2plasma.R
\name{calc_rblood2plasma}
\alias{calc_rblood2plasma}
\title{Calculate the constant ratio of the blood concentration to the plasma
concentration.}
\usage{
calc_rblood2plasma(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  hematocrit = NULL,
  Krbc2pu = NULL,
  Funbound.plasma = NULL,
  default.to.human = FALSE,
  species = "Human",
  adjusted.Funbound.plasma = TRUE,
  class.exclude = TRUE,
  suppress.messages = TRUE
)
}
\arguments{
\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from \code{\link{parameterize_schmitt}}}

\item{hematocrit}{Overwrites default hematocrit value in calculating
Rblood2plasma.}

\item{Krbc2pu}{The red blood cell to unbound plasma chemical partition
coefficient, typically from \code{\link{predict_partitioning_schmitt}}}

\item{Funbound.plasma}{The fraction of chemical unbound (free) in the
presence of plasma protein}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{adjusted.Funbound.plasma}{Whether or not to use Funbound.plasma
adjustment.}

\item{class.exclude}{Exclude chemical classes identified as outside of 
domain of applicability by relevant modelinfo_[MODEL] file (default TRUE).}

\item{suppress.messages}{Determine whether to display certain usage
feedback.}
}
\value{
The blood to plasma chemical concentration ratio
}
\description{
This function calculates the constant ratio of the blood concentration to
the plasma concentration.
}
\details{
The red blood cell (RBC) parition coefficient as predicted by the Schmitt
(2008) method is used in the calculation. The value is calculated with the
equation: 1 - hematocrit + hematocrit * Krbc2pu * Funbound.plasma, summing
the red blood cell to plasma and plasma:plasma (equal to 1) partition
coefficients multiplied by their respective fractional volumes. When
species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data (hematocrit and temperature), but substitutes
human fraction unbound and tissue volumes.
}
\examples{

calc_rblood2plasma(chem.name="Bisphenol A")
calc_rblood2plasma(chem.name="Bisphenol A",species="Rat")

}
\references{
\insertRef{schmitt2008general}{httk}

\insertRef{pearce2017evaluation}{httk}

\insertRef{ruark2014predicting}{httk}
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
