% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-as-marray.r, R/method-as-mmatrix.r,
%   R/method-as-mvector.r
\name{as.marray}
\alias{as.marray}
\alias{as.marray,array-method}
\alias{as.mmatrix}
\alias{as.mmatrix,matrix-method}
\alias{as.mvector}
\alias{as.mvector,numeric-method}
\title{Conversion of R objects to memory mapped objects}
\usage{
as.marray(x, datatype, filename)

\S4method{as.marray}{array}(x, datatype, filename)

as.mmatrix(x, datatype, filename)

\S4method{as.mmatrix}{matrix}(x, datatype, filename)

as.mvector(x, datatype, filename)

\S4method{as.mvector}{numeric}(x, datatype, filename)
}
\arguments{
\item{x}{an r object}

\item{datatype}{(optional) type of the memory mapped object}

\item{filename}{(optional) path to file}
}
\value{
A memmory-mapped object, of class 'mvector', 'mmatrix' or 'marray'
}
\description{
Conversion of R objects to memory mapped objects
}
\details{
If 'filename' is a path to an existing file, the function will raise an error.
If you need to overwrite a file, unlink it first.
}
\examples{
a <- matrix(1:6, 2)
A <- as.mmatrix(a)
B <- as.mmatrix(a, "float")
A
B

}
