% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{aggregateTrades}
\alias{aggregateTrades}
\title{Aggregate a \code{data.table} or \code{xts} object containing trades data´}
\usage{
aggregateTrades(
  tData,
  alignBy = "minutes",
  alignPeriod = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = NULL
)
}
\arguments{
\item{tData}{\code{data.table} or \code{xts} object to be aggregated, containing the intraday price series of a stock for possibly multiple days.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. Possible values are: \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}.
To aggregate based on a 5 minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5 minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{marketOpen}{the market opening time, by default: \code{marketOpen = "09:30:00"}.}

\item{marketClose}{the market closing time, by default: \code{marketClose = "16:00:00"}.}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. We attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}}
}
\value{
A \code{data.table} or \code{xts} object containing the aggregated time series.
}
\description{
Aggregate tick-by-tick trade data and return a time series as a \code{data.table} or \code{xts} object where first observation is always the opening price
and subsequent observations are the closing prices over the interval. This function accepts arbitrary number of symbols over an arbitrary number of days.
}
\details{
The time stamps of the new time series are the closing times and/or days of the intervals. 

The output \code{"PRICE"} column is constructed using previous tick aggregation.

The variable \code{"SIZE"} is aggregated by taking the sum over each interval.

The variable \code{"VWPRICE"} is the aggregated price weighted by volume.

The time stamps of the new time series are the closing times of the intervals. 

In case of previous tick aggregation or \code{alignBy = "seconds"/"minutes"/"hours"},
the element of the returned series with e.g. time stamp 09:35:00 contains 
the last observation up to that point, including the value at 09:35:00 itself.
}
\examples{
# Aggregate trade data to 5 minute frequency
tDataAggregated <- aggregateTrades(sampleTData, alignBy = "minutes", alignPeriod = 5)
tDataAggregated
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{data}
\keyword{manipulation}
