% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{icer_tbl}
\alias{icer_tbl}
\title{ICER table}
\usage{
icer_tbl(
  x,
  k = 50000,
  cri = TRUE,
  prob = 0.95,
  digits_qalys = 2,
  digits_costs = 0,
  output = c("matrix", "data.table"),
  rownames = NULL,
  colnames = NULL,
  drop = TRUE
)
}
\arguments{
\item{x}{An object of class \code{cea_pw} returned by \code{\link[=cea_pw]{cea_pw()}}.}

\item{k}{Willingness to pay.}

\item{cri}{If \code{TRUE}, credible intervals are computed; otherwise
they are not.}

\item{prob}{A numeric scalar in the interval \verb{(0,1)} giving the credible interval.
Default is 0.95 for a 95 percent credible interval.}

\item{digits_qalys}{Number of digits to use to report QALYs.}

\item{digits_costs}{Number of digits to use to report costs.}

\item{output}{Should output be a \code{data.table} or a list of matrices for
each group.}

\item{rownames}{Row names for matrices when \code{output = "matrix"}.}

\item{colnames}{Column names for matrices when \code{output = "matrix"}.}

\item{drop}{If \code{TRUE}, then the result is coerced to the lowest possible dimension.
Relevant if \code{output = "matrix"} and there is one group, in which case a single
matrix will be returned if \code{drop = TRUE} and a list of length 1 will be returned
if \code{drop = FALSE}.}
}
\value{
If \code{output = "matrix"}, then a list of matrices (or a matrix if
\code{drop = TRUE}) reporting incremental cost-effectiveness ratios (ICERs)
by group. Specifically, each matrix contains five rows for: (i)
incremental quality-adjusted life-years (QALYs), (ii) incremental costs,
(iii) the incremental net monetary benefit (NMB), (iv) the ICER,
and (v) a conclusion stating whether each strategy is cost-effective relative
to a comparator. The number of columns is equal to the
number of strategies (including the comparator).

If \code{output = "data.table"}, then the results are reported as a \code{data.table},
with one row for each strategy and group combination.
}
\description{
Generate a table of incremental cost-effectiveness ratios given output from
\code{\link[=cea_pw]{cea_pw()}}.
}
\seealso{
\code{\link[=cea_pw]{cea_pw()}}
}
\keyword{internal}
