% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipse.box.R
\name{ellipse.box}
\alias{ellipse.box}
\title{Draw Conjugate Axes and Parallelogram Surrounding a Covariance Ellipse}
\usage{
ellipse.box(
  x,
  center = c(0, 0),
  which = 1:2,
  level = 0.95,
  radius = sqrt(qchisq(level, 2)),
  factor = c("cholesky", "pca"),
  draw = c("box", "diameters", "both"),
  ...
)
}
\arguments{
\item{x}{A square positive definite matrix at least 2x2 in size.  It will be
treated as the correlation or covariance of a multivariate normal
distribution.}

\item{center}{The center of the ellipse}

\item{which}{An integer vector to select which variables from the object \code{x} will be
plotted.  The default is the first 2.}

\item{level}{The coverage level of a simultaneous region of the ellipse.  The
default is 0.95, for a 95\\% region.  This is used to control the size of the
ellipse.}

\item{radius}{The size of the ellipsoid may also be controlled by specifying the
value of a t-statistic on its boundary. This defaults to the square root of a chi-square statistic
for a given \code{level} on 2 degrees of freedom, however in a small sample of \code{n} observations,
a more accurate value is \code{sqrt(2 * qf(level, 2, n - 1 ))}.}

\item{factor}{A function defining the conjugate axes used to transform the unit
circle into an ellipse.  \code{\link{chol}}, uses the right Cholesky
factor of \code{x}.}

\item{draw}{What to draw? \code{"box"}, \code{"diameters"} or \code{"both"}}

\item{\dots}{Other arguments passed to \code{\link[graphics]{lines}}.}
}
\value{
Invisibly returns a 2 column matrix containing the end points of lines.
}
\description{
Draw Conjugate Axes and Parallelogram Surrounding a Covariance Ellipse
}
\examples{
data(iris)
cov <- cov(iris[,3:4])
mu <- colMeans(iris[,3:4])

radius <- sqrt(qchisq(0.68, 2))
plot(iris[,3:4], asp=1)
car::ellipse(mu, cov, radius = radius)
ellipse.axes(cov, center=mu, level = 0.68,
            labels = TRUE)
ellipse.box(cov, center=mu, level = 0.68, 
            factor = "pca", 
            col = "red", lwd = 2 )

res <- ellipse.box(cov, center=mu, level = 0.68, factor = "chol", col = "green", lwd = 2 )
res
}
\seealso{
Other covariance ellipses: 
\code{\link{covEllipses}()},
\code{\link{ellipse.axes}()},
\code{\link{ellipse3d.axes}()}
}
\concept{covariance ellipses}
