% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbcc.R
\name{hbcc}
\alias{hbcc}
\title{hbcc : Hierarchical Bayesian Convergence Checks}
\usage{
hbcc(
  model,
  diag_tests = c("rhat", "geweke", "heidel", "raftery"),
  plot_types = c("trace", "dens", "acf", "nuts_energy", "rhat", "neff")
)
}
\arguments{
\item{model}{A \code{brmsfit} or \code{hbmfit} object.}

\item{diag_tests}{Character vector of diagnostic tests (default:"rhat", "geweke", "raftery", "heidel")}

\item{plot_types}{Character vector of plot types (default: trace","dens","acf", "nuts_energy", "rhat", "neff")}
}
\value{
An object of class \code{hbcc_results}, which is a list containing:
\item{rhat_ess}{Matrix of \code{Rhat}, \code{Bulk_ESS}, and \code{Tail_ESS} values for fixed and random effects.}
\item{geweke}{Geweke diagnostic results (if selected).}
\item{raftery}{Raftery-Lewis diagnostic results (if selected).}
\item{heidel}{Heidelberger-Welch diagnostic results (if selected).}
\item{plots}{A list of generated MCMC diagnostic plots, which may include:}
\itemize{
\item \code{"trace"} - Trace plot of the MCMC chains.
\item \code{"dens"} - Density plot of the posterior distributions.
\item \code{"acf"} - Autocorrelation function plot.
\item \code{"nuts_energy"} - NUTS energy diagnostic plot.
\item \code{"rhat"} - Rhat plot (if available).
\item \code{"neff"} - Effective sample size plot.
}
}
\description{
This function is designed to evaluate the convergence and quality of a Bayesian hierarchical model.
It performs several diagnostic tests and generates various plots to assess Markov Chain Monte Carlo  performance.
}
\details{
Hierarchical Bayesian Convergence Checks
}
\examples{
\donttest{

library(hbsaems)
data("data_fhnorm")

# Prepare the dataset
data <- data_fhnorm

# Fit the Basic Model
model <- hbm(
formula = bf(y ~ x1 + x2 + x3), # Formula model
hb_sampling = "gaussian", # Gaussian family for continuous outcomes
hb_link = "identity", # Identity link function (no transformation)
data = data, # Dataset
chains = 4, # Number of MCMC chains
iter = 4000, # Total MCMC iterations
warmup = 2000, # Number of warmup iterations
cores = 2 # Parallel processing
)
summary(model)

# Convergence Checks
hbcc(model)
}

}
\references{
Bürkner, P. C. (2017). brms: An R package for Bayesian multilevel models using Stan. \emph{Journal of Statistical Software}, 80(1), 1-28.
}
\author{
Achmad Syahrul Choir and Saniyyah Sri Nurhayati
}
