% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{templateK40}
\alias{templateK40}
\title{Cluster Template with 40 Clusters}
\format{
A list containing the contents of the cluster template.
\describe{
\item{cluster}{A vector of cluster assignments
for each graph used to create the cluster template. The clusters are numbered sequentially 1, 2,...,K.}
\item{centers}{The final cluster centers produced by the K-Means algorithm.}
\item{K}{The number of clusters in the template.}
\item{n}{The number of training graphs to used to create the template.}
\item{iters}{The maximum number of iterations for the K-means
algorithm.}
\item{WithinClustDists}{The within cluster
distances on the final iteration of the K-means algorithm. More specifically,
the distance between each graph and the center of the cluster to which it
was assigned  on each iteration. The output of \code{\link{make_clustering_template}} stores
the within cluster distances on each iteration, but the previous iterations were removed here to reduce the file size.}}
}
\usage{
templateK40
}
\description{
A cluster template with 40 clusters created with
\code{\link{make_clustering_template}}. This template was created from handwriting
samples from the CSAFE Handwriting Database, the CVL Handwriting Database,
and the IAM Handwriting Database.
}
\details{
'handwriter' splits handwriting samples into component shapes called
graphs. The graphs are sorted into 40 clusters with a K-Means algorithm.
}
\examples{
# view number of clusters
templateK40$K

# view number of iterations
templateK40$iters

# view cluster centers
plot_cluster_centers(templateK40)

}
\keyword{cluster}
