% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_plot.R
\name{plot_writer_profiles}
\alias{plot_writer_profiles}
\title{Plot Writer Profiles}
\usage{
plot_writer_profiles(profiles, color_by = "docname", ...)
}
\arguments{
\item{profiles}{A data frame of writer profiles created with
\code{{get_writer_profiles}}.}

\item{color_by}{A column name. 'ggplot2' will always group by docname, but
will use this column to assign colors.}

\item{...}{Additional arguments passed to \code{ggplot2::facet_wrap}, such as
\code{facets}, \code{nrow}, etc.}
}
\value{
A line plot
}
\description{
Create a line plot of writer profiles for one or more documents.
}
\examples{
\donttest{
docs <- system.file(file.path("extdata"), package = "handwriter")
profiles <- get_writer_profiles(docs, measure = "counts")
plot_writer_profiles(profiles)

profiles <- get_writer_profiles(docs, measure = "rates")
plot_writer_profiles(profiles)
}

}
