% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_models.R
\name{select_models}
\alias{select_models}
\title{Stepwise Model Selection with Evaluation Metrics}
\usage{
select_models(
  data,
  outcome,
  exposures,
  approach = "logit",
  direction = "forward"
)
}
\arguments{
\item{data}{A data frame containing the outcome and predictor variables.}

\item{outcome}{A character string indicating the outcome variable.}

\item{exposures}{vector of predictor variables to consider in the model.}

\item{approach}{Regression method. One of:
\code{"logit"}, \code{"log-binomial"}, \code{"poisson"},
\code{"robpoisson"}, \code{"negbin"}, or \code{"linear"}.}

\item{direction}{Stepwise selection direction. One of:
\code{"forward"} (default), \code{"backward"}, or \code{"both"}.}
}
\value{
A list with the following components:
\itemize{
  \item \code{results_table}: A tibble summarising each tested model's metric
  (AIC, BIC, deviance, log-likelihood, adjusted R² if applicable).
  \item \code{best_model}: The best-fitting model object based on low AIC.
  \item \code{all_models}: A named list of all fitted models.
}
}
\description{
Performs stepwise model selection using forward, backward, or both directions
 across different regression approaches.
Returns a summary table with evaluation
metrics (AIC, BIC, log-likelihood, deviance) and the best model.
}
\examples{
data <- data_PimaIndiansDiabetes
stepwise <- select_models(
  data = data,
  outcome = "glucose",
  exposures = c("age", "pregnant", "mass"),
  approach = "linear",
  direction = "forward"
)
summary(stepwise)
stepwise$results_table
stepwise$best_model

}
