% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_bmkDF.R
\name{stack_bmkDF}
\alias{stack_bmkDF}
\title{Stack benchmarks data}
\usage{
stack_bmkDF(
  bmk_df,
  ser_cName = "series",
  startYr_cName = "startYear",
  startPer_cName = "startPeriod",
  endYr_cName = "endYear",
  endPer_cName = "endPeriod",
  val_cName = "value",
  keep_NA = FALSE
)
}
\arguments{
\item{bmk_df}{(mandatory)

Data frame (object of class "data.frame") that contains the multivariate benchmarks to be stacked.}

\item{ser_cName}{(optional)

String specifying the name of the character variable (column) in the output stacked data frame that will
contain the benchmark names (name of the benchmark variables in the input multivariate benchmarks data
frame). This variable can then be used as the BY-group variable (argument \code{by}) with the benchmarking functions.

\strong{Default value} is \code{ser_cName = "series"}.}

\item{startYr_cName, startPer_cName, endYr_cName, endPer_cName}{(optional)

Strings specifying the name of the numeric variables (columns) in the input multivariate benchmarks data frame
that define the benchmark coverage, i.e., the starting and ending year and period (cycle) identifiers. These variables
are \emph{transferred} to the output stacked data frame with the same variable names.

\strong{Default values} are \code{startYr_cName = "startYear"}, \code{startPer_cName = "startPeriod"}
\code{endYr_cName = "endYear"} and \code{endPer_cName   = "endPeriod"}.}

\item{val_cName}{(optional)

String specifying the name of the numeric variable (column) in the output stacked data frame that will
contain the benchmark values.

\strong{Default value} is \code{val_cName = "value"}.}

\item{keep_NA}{(optional)

Logical argument specifying whether missing (\code{NA}) benchmark values in the input multivariate benchmarks data frame
should be kept in the output stacked data frame.

\strong{Default value} is \code{keep_NA = FALSE}.}
}
\value{
The function returns a data frame with six variables:
\itemize{
\item Benchmark (series) name, type character (see argument \code{ser_cName})
\item Benchmark coverage starting year, type numeric (see argument \code{startYr_cName})
\item Benchmark coverage starting period, type numeric (see argument \code{startPer_cName})
\item Benchmark coverage ending year, type numeric (see argument \code{endtYr_cName})
\item Benchmark coverage ending period, type numeric (see argument \code{endPer_cName})
\item Benchmark value, type numeric (see argument \code{val_cName})
}

Note: the function returns a "data.frame" object than can be explicitly coerced to another type of object
with the appropriate \verb{as*()} function (e.g., \code{tibble::as_tibble()} would coerce it to a tibble).
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/stack_bmkDF.html}})}

Convert a multivariate benchmarks data frame (see \code{\link[=ts_to_bmkDF]{ts_to_bmkDF()}}) for the benchmarking functions
(\code{\link[=benchmarking]{benchmarking()}} and \code{\link[=stock_benchmarking]{stock_benchmarking()}}) into a stacked (tall) data frame with six variables (columns):
\itemize{
\item one (1) for the benchmark name (e.g., series name)
\item four (4) for the benchmark coverage
\item one (1) for the benchmark value
}

Missing (\code{NA}) benchmark values are not included in the output stacked data frame by default. Specify argument
\code{keep_NA = TRUE} in order to keep them.

This function is useful when intending to use the \code{by} argument (\emph{BY-group} processing mode) of the benchmarking
functions in order to benchmark multiple series in a single function call.
}
\examples{
# Create an annual benchmarks data frame for 2 quarterly indicator series 
# (with missing benchmark values for the last 2 years)
my_benchmarks <- ts_to_bmkDF(ts(data.frame(ser1 = c(1:3 *  10, NA, NA), 
                                           ser2 = c(1:3 * 100, NA, NA)), 
                                start = c(2019, 1), frequency = 1),
                             ind_frequency = 4)
my_benchmarks


# Stack the benchmarks ...

# discarding `NA` values in the output stacked data frame (default behavior)
stack_bmkDF(my_benchmarks)

# keep `NA` values in the output stacked data frame
stack_bmkDF(my_benchmarks, keep_NA = TRUE)

# using custom variable (column) names
stack_bmkDF(my_benchmarks, ser_cName = "bmk_name", val_cName = "bmk_val")
}
\seealso{
\code{\link[=stack_tsDF]{stack_tsDF()}} \code{\link[=ts_to_bmkDF]{ts_to_bmkDF()}} \code{\link[=benchmarking]{benchmarking()}} \code{\link[=stock_benchmarking]{stock_benchmarking()}}
}
