% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gremlin.R
\name{nobs.gremlin}
\alias{nobs.gremlin}
\title{Number of observations in data from gremlin model fit objects}
\usage{
\method{nobs}{gremlin}(object, use.fallback = FALSE, ...)
}
\arguments{
\item{object}{An object of \code{class} \sQuote{gremlin}.}

\item{use.fallback}{logical: should fallback methods be used to try to guess
the value? Included for compatibility.}

\item{\dots}{Further arguments to be passed to the methods.}
}
\value{
A single number, usually an \code{integer}, but can be \code{NA}.
}
\description{
Extract the number of 'observations' in a gremlin model fit.
}
\examples{
grS <- gremlin(WWG11 ~ sex - 1, random = ~ sire, data = Mrode11)
nobs(grS)
}
\author{
\email{matthewwolak@gmail.com}
}
