% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_graph.R
\name{as_initial_graph}
\alias{as_initial_graph}
\alias{as_initial_graph.graphMCP}
\alias{as_initial_graph.igraph}
\alias{as_graphMCP}
\alias{as_graphMCP.initial_graph}
\alias{as_igraph}
\alias{as_igraph.initial_graph}
\title{Convert between graphicalMCP, gMCP, and igraph graph classes}
\usage{
as_initial_graph(graph)

\method{as_initial_graph}{graphMCP}(graph)

\method{as_initial_graph}{igraph}(graph)

as_graphMCP(graph)

\method{as_graphMCP}{initial_graph}(graph)

as_igraph(graph)

\method{as_igraph}{initial_graph}(graph)
}
\arguments{
\item{graph}{An \code{initial_graph} object from the \code{graphicalMCP} package, a
\code{graphMCP} object from the \code{gMCP} package, or an \code{igraph} object from the
\code{igraph} package, depending on the conversion type.}
}
\value{
\itemize{
\item \code{as_graphMCP()} returns a \code{graphMCP} object for the \code{gMCP} package.
\item \code{as_igraph()} returns an \code{igraph} object for the \code{igraph} package.
\item \code{as_initial_graph()} returns an \code{initial_graph} object for the
\code{graphicalMCP} package.
}
}
\description{
Graph objects have different structures and attributes in
\code{graphicalMCP}, \code{gMCP}, and \code{igraph} R packages. These functions convert
between different classes to increase compatibility.

Note that \code{igraph} and \code{gMCP} have additional attributes for vertices, edges,
or a graph itself. These conversion functions only handle attributes related
to hypothesis names, hypothesis weights and transition weights. Other
attributes will be dropped when converting.
}
\examples{
g_graphicalMCP <- random_graph(5)

if (requireNamespace("gMCP", quietly = TRUE)) {
  g_gMCP <- as_graphMCP(g_graphicalMCP)

  all.equal(g_graphicalMCP, as_initial_graph(g_gMCP))
}

if (requireNamespace("igraph", quietly = TRUE)) {
  g_igraph <- as_igraph(g_graphicalMCP)

  all.equal(g_graphicalMCP, as_initial_graph(g_igraph))
}
}
\references{
Csardi, G., Nepusz, T., Traag, V., Horvat, S., Zanini, F., Noom,
D., and Mueller, K. (2024). \emph{igraph}: Network analysis and visualization
in R. R package version 2.0.3.
\url{https://CRAN.R-project.org/package=igraph}.

Rohmeyer, K., and Klinglmueller, K. (2024). \emph{gMCP}: Graph based multiple
test procedures. R package version 0.8-17.
\url{https://cran.r-project.org/package=gMCP}.
}
\seealso{
\code{\link[=graph_create]{graph_create()}} for the initial graph used in the \code{graphicalMCP}
package.
}
