% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_examples.R
\name{generate_random_integer_Gamma}
\alias{generate_random_integer_Gamma}
\title{Generate a random Gamma matrix containing only integers}
\usage{
generate_random_integer_Gamma(d, b = 2, b_step = 1)
}
\arguments{
\item{d}{Number of rows/columns in the output matrix}

\item{b}{Initial \code{b} used in the algorithm described above}

\item{b_step}{By how much \code{b} is increased in each iteration}
}
\value{
A numeric \dxd variogram matrix with integer entries
}
\description{
Generates a random variogram Matrix by producing a \d1xd1 matrix \code{B} with random
integer entries between \code{-b} and \code{b}, computing \code{S = B \%*\% t(B)},
and passing this \code{S} to \code{\link[=Sigma2Gamma]{Sigma2Gamma()}}.
This process is repeated with an increasing \code{b} until a valid Gamma matrix
is produced.
}
\examples{

generate_random_integer_Gamma(5, 2, 0.1)

}
\seealso{
Other example generation functions:
\code{\link{generate_random_Gamma}()},
\code{\link{generate_random_chordal_graph}()},
\code{\link{generate_random_graphical_Gamma}()},
\code{\link{generate_random_model}()},
\code{\link{generate_random_spd_matrix}()}
}
\concept{exampleGenerations}
