% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-attributes.R
\name{gpkg_write_attributes}
\alias{gpkg_write_attributes}
\alias{gpkg_remove_attributes}
\title{Write or Remove Attribute Table in a GeoPackage}
\usage{
gpkg_write_attributes(
  x,
  table,
  table_name,
  description = "",
  template = NULL,
  overwrite = FALSE,
  append = FALSE
)

gpkg_remove_attributes(x, table_name)
}
\arguments{
\item{x}{A \code{geopackage} object}

\item{table}{A \code{data.frame}}

\item{table_name}{\code{character}. The name for \code{table} in \code{x}}

\item{description}{Optional description. Default \code{""}}

\item{template}{A \code{list} (containing elements \code{"ext"} and \code{"crs"}, or a \code{terra} object. These objects defining xmin/ymin/xmax/ymax and spatial reference system for the attribute table.}

\item{overwrite}{Overwrite? Default \code{FALSE}}

\item{append}{Append? Default \code{FALSE}}
}
\value{
\code{logical}. \code{TRUE} on successful table write or remove.
}
\description{
\code{gpkg_write_attributes()}: Specify a target geopackage and name for new table. For adding attributes, specify the new data as data.frame. The table name will be registered in the \code{gpkg_contents} table. Optionally include a custom \code{description} and/or use a \code{template}  object to define the spatial extent associated with attribute data.

\code{gpkg_remove_attributes()}: Remove an attribute table and corresponding \code{gpkg_contents} record
}
