% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcp.R
\name{runGPCP}
\alias{runGPCP}
\title{Genomic Prediction of Cross Performance
This function performs genomic prediction of cross performance using genotype and phenotype data.}
\usage{
runGPCP(
  phenotypeFile,
  genotypeFile,
  genotypes,
  traits,
  weights = NA,
  userSexes = "",
  userFixed = NA,
  userRandom = NA,
  Ploidy = NA,
  NCrosses = NA
)
}
\arguments{
\item{phenotypeFile}{A data frame containing phenotypic data, typically read from a CSV file.}

\item{genotypeFile}{Path to the genotypic data, either in VCF or HapMap format.}

\item{genotypes}{A character string representing the column name in the phenotype file for the genotype IDs.}

\item{traits}{A string of comma-separated trait names from the phenotype file.}

\item{weights}{A numeric vector specifying weights for the traits.}

\item{userSexes}{A string representing the column name corresponding to the individuals' sexes.}

\item{userFixed}{A string of comma-separated fixed effect variables.}

\item{userRandom}{A string of comma-separated random effect variables.}

\item{Ploidy}{An integer representing the ploidy level of the organism.}

\item{NCrosses}{An integer specifying the number of top crosses to output.}
}
\value{
A data frame containing predicted cross performance.
}
\description{
Genomic Prediction of Cross Performance
This function performs genomic prediction of cross performance using genotype and phenotype data.
}
\examples{
# Load phenotype data from CSV
phenotypeFile <- read.csv(system.file("extdata", "phenotypeFile.csv", package = "gpcp"))
genotypeFile <- system.file("extdata", "genotypeFile_Chr9and11.vcf", package = "gpcp")
finalcrosses <- runGPCP(
    phenotypeFile = phenotypeFile,
    genotypeFile = genotypeFile,
    genotypes = "Accession",
    traits = "YIELD,DMC",
    weights = c(3, 1),
    userFixed = "LOC,REP",
    Ploidy = 2,
    NCrosses = 150
)
print(finalcrosses)
}
