% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{build_tour_greedy}
\alias{build_tour_greedy}
\title{Building a tour for a TSP using the greedy heuristic}
\usage{
build_tour_greedy(d, n)
}
\arguments{
\item{d}{Distance matrix of the TSP.}

\item{n}{Number of vertices of the TSP complete graph.}
}
\value{
A list with two components: $tour contains a permutation
of the 1:n sequence representing the tour constructed by the
algorithm, and $distance contains the value of the distance
covered by the tour.
}
\description{
Greedy heuristic tour-building algorithm for the Traveling
Salesperson Problem
}
\details{
The greedy heuristic begins by sorting the edges by increasing
distance.  The tour is constructed by adding an edge under the
condition that the final tour is a connected spanning cycle.
}
\examples{
## Regular example with obvious solution (minimum distance 48)
m <- 10   # Generate some points in the plane
z <- cbind(c(rep(0,m), rep(2,m), rep(5,m), rep(7,m)), rep(seq(0,m-1),4))
n <- nrow(z)
d <- compute_distance_matrix(z)
b <- build_tour_greedy(d, n)
b$distance    # Distance 50
plot_tour(z,b)

## Random points
set.seed(1)
n <- 25
z <- cbind(runif(n,min=1,max=10),runif(n,min=1,max=10))
d <- compute_distance_matrix(z)
b <- build_tour_greedy(d, n)
b$distance    # Distance 36.075
plot_tour(z,b)

}
\seealso{
\link{build_tour_nn} uses the nearest neighbor heuristic,
\link{build_tour_nn_best} repeats the previous algorithm with all
possible starting points, \link{compute_tour_distance} computes
tour distances, \link{compute_distance_matrix} computes a distance
matrix, \link{plot_tour} plots a tour, \link{build_tour_2tree}
constructs a tour using the double tree 2-factor approximation
algorithm.
}
\author{
Cesar Asensio
}
