% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_drive.R
\name{deprecated-team-drive-functions}
\alias{deprecated-team-drive-functions}
\alias{team_drive_find}
\alias{team_drive_get}
\alias{team_drive_create}
\alias{team_drive_rm}
\alias{team_drive_update}
\alias{as_team_drive}
\alias{is_team_drive}
\title{Deprecated Team Drive functions}
\usage{
team_drive_find(pattern = NULL, n_max = Inf, ..., verbose = deprecated())

team_drive_get(name = NULL, id = NULL, verbose = deprecated())

team_drive_create(name, verbose = deprecated())

team_drive_rm(team_drive = NULL, verbose = deprecated())

team_drive_update(team_drive, ..., verbose = deprecated())

as_team_drive(x, ...)

is_team_drive(d)
}
\arguments{
\item{pattern}{Character. If provided, only the items whose names match this
regular expression are returned. This is implemented locally on the results
returned by the API.}

\item{n_max}{Integer. An upper bound on the number of items to return. This
applies to the results requested from the API, which may be further
filtered locally, via the \code{pattern} argument.}

\item{...}{Other parameters to pass along in the request, such as \code{pageSize}
or \code{useDomainAdminAccess}.}

\item{name}{Character vector of names. A character vector marked with
\code{\link[=as_id]{as_id()}} is treated as if it was provided via the \code{id} argument.}

\item{id}{Character vector of shared drive ids or URLs (it is first processed
with \code{\link[=as_id]{as_id()}}). If both \code{name} and \code{id} are non-\code{NULL}, \code{id} is silently
ignored.}

\item{team_drive}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Google Drive and the
Drive API have replaced Team Drives with shared drives.}

\item{x}{A vector of shared drive names, a vector of shared drive ids marked
with \code{\link[=as_id]{as_id()}}, a list of Drives resource objects, or a suitable data
frame.}

\item{d}{A \code{\link{dribble}}.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per shared drive.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Team Drives have been rebranded as \emph{shared drives} and, as of googledrive
v2.0.0, all \verb{team_drive_*()} functions have been deprecated, in favor of
\verb{shared_drive_*()} successors.

The changes in googledrive reflect that the Team Drives resource collection
has been deprecated in the Drive API v3, in favor of the new (shared) Drives
resource collection. Read more
\itemize{
\item \url{https://cloud.google.com/blog/products/application-development/upcoming-changes-to-the-google-drive-api-and-google-picker-api}
}
}
\keyword{internal}
