% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interactions_all_vs_all.R
\name{pairwise_int.calc}
\alias{pairwise_int.calc}
\title{Pairwise interaction effects}
\usage{
pairwise_int.calc(
  qt,
  g,
  round_imputed = FALSE,
  dominance_terms = FALSE,
  variant_names = paste(rep("variant", ncol(g)), as.character(1:ncol(g)), sep = "_"),
  covariates = as.data.frame(matrix(0, nrow = 0, ncol = 0))
)
}
\arguments{
\item{qt}{A numeric vector}

\item{g}{A matrix, where each colomn represents a variant}

\item{round_imputed}{A boolian variable determining whether imputed genotype values should be rounded to the nearest integer in the analysis.}

\item{dominance_terms}{A boolian variable determining whether dominance terms for the variants should be included as covariates in the analysis}

\item{variant_names}{A list of the names of the variants}

\item{covariates}{A dataframe containing any other covariates that should be used; one column per covariate}
}
\value{
A dataframe with all possible variant pairs and their estimated interaction effect
}
\description{
Given a set of variants and a quantitative trait, this function calculates the interaction effect of all possible variant-variant pairs
}
\examples{
g_vec <- matrix(0, nrow = 100000, ncol = 5)
freqs <- runif(ncol(g_vec), min = 0, max = 1)
for(i in 1:ncol(g_vec)){
 g_vec[,i] <- rbinom(100000, 2, freqs[i])
}

qt_vec <- rnorm(100000) + 0.1 * g_vec[, 1] + 0.2 *
          g_vec[, 2] -0.1 * g_vec[, 3] + 0.2 *
          g_vec[, 1] * g_vec[, 2]
res <- pairwise_int.calc(qt_vec, g_vec)
}
