% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_calibration.R
\name{corr.calibration}
\alias{corr.calibration}
\title{Calibration for the correlation test}
\usage{
corr.calibration(qt1, qt2, reps = 10000)
}
\arguments{
\item{qt1}{A numeric vector.}

\item{qt2}{A numeric vector.}

\item{reps}{The number of repeates we want to perform for each sample size}
}
\value{
A list with the values:

* bias_scale, a value to determine the bias for the correlation estimators
* weight_scale, a value to determine how much weight we assign to each correlation estimator
* safe_weight_scale, same as weight scale, but larger. Using this weight decreases the chance of type 1 error, with the cost of statistical power.
}
\description{
This function finds appropriate scaling_parameters for the kappa_calc function by means of bootstrapping.
}
\examples{
n_val <- 10000
Q <- MASS::mvrnorm(n = n_val, mu = c(0,0), Sigma = matrix(c(1,0.3,0.3,1),
                   nrow = 2, ncol = 2))
qt1_val <- Q[,1]
qt2_val <- Q[,2]
res <- corr.calibration(qt1_val, qt2_val, 10)
}
