% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_model.R
\name{alpha.calc}
\alias{alpha.calc}
\title{Genetic variance effects}
\usage{
alpha.calc(qt, g)
}
\arguments{
\item{qt}{A numeric vector.}

\item{g}{An integer vector.}
}
\value{
A list with the values:

* alpha, the estimated variance effect
* sigma2_alt, The variance estimated for non-carriers
* pval, the p-value of the likelihood ratio test
* chi2, the chi squared statistics (with one degree of freedom) corrisponding to the p-value
}
\description{
This function estimates the variance effect of a genetic variant on a quantitative trait.
The genotype is coded as 0 (non-carrier), 1 (single copy of effect allele) and 2 (two copies of effect allele).
The variance effect (alpha) is modelled to be multiplicitive.
We use a likelihood ratio test with 1 degree of freedom,
* H0: y~N(mu_g,sigma^2)
* H1: y~N(mu_g,sigma^2\*alpha^g)
Under the alternative model, the variance of the trait changes multiplicatively
with genotype:
    Var(y|g=j)=alpha^j*sigma^2, j in 0,1,2
}
\examples{
n_val <- 50000L
geno_vec <- sample(c(0, 1, 2), size = n_val, replace = TRUE)
qt_vec <- rnorm(n_val) * (1.1^geno_vec)
res <- alpha.calc(qt_vec, geno_vec)
}
