% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emforbeta.R
\name{emforbeta}
\alias{emforbeta}
\title{Fitting binary regression with missing categorical covariates using likelihood based method}
\usage{
emforbeta(
  formula,
  data,
  family = "binomial",
  vcorctn = FALSE,
  method = "glm.fit",
  NIterations = 50,
  verbose = FALSE,
  theta = NULL,
  convergenceCriterion = 1e-04,
  augmented = NULL,
  VarWithMissingVal = NULL
)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form response ~ predictors. The response should be a numeric binary variable with missing values, and predictors can be any variables. A predictor with categorical values with missing can be used in the model. See the documentation of formula for other details.}

\item{data}{Input data for fitting the model}

\item{family}{a character string specifying the type of model family. The default is family=binomial (lin=logit)}

\item{vcorctn}{a TRUE or FALSE value, by default it is FALSE. If TRUE, it calculates a variance and standard error using Louis (1982)}

\item{method}{a method="brglmFit" or method="glm.fit" will be used for fitting model. The method="brglmFit" fits generalized linear models using bias reduction methods (Kosmidis, 2014), and other penalized maximum likelihood methods.The deafult option method="glm.fit" fits regression with generalized linear models.}

\item{NIterations}{is the number of iterations to be used for convergence. The default is NIterations=50}

\item{verbose}{a TRUE or FALSE value, by default it is FALSE. A value TRUE prints all intermediate computational details}

\item{theta}{a vector containing multinomial parameters that sums to 1, default is NULL}

\item{convergenceCriterion}{Convergence criteria to be used for convergence. The default is 1e-4}

\item{augmented}{is the name of an augmented data. The default is NULL}

\item{VarWithMissingVal}{is a vector of variables including missing values. The default is NULL}
}
\value{
return the glm estimates
}
\description{
This function allows users to fit generalized linear models with incomplete predictors that are categorical. The model is fitted using a likelihood-based method, which ensures reliable parameter estimation even when dealing with missing data. For more information on the underlying methodology, please refer to Pradhan, Nychka, and Bandyopadhyay (2025).
}
\details{
The \code{family} parameter in the \code{emforbeta} function allows you to specify the probability distribution and link function for the response variable in the linear model. It determines the nature of the relationship between the predictors and the response variable.
The \code{family} argument is particularly important when working with binary data, where the response variable has only two possible outcomes. In such cases, you typically want to fit a logistic regression model.

The following commonly used families are supported for binary data:
\itemize{
\item "binomial" for a binomial distribution, suitable for binary or dichotomous response variables.
}

You can also specify different link functions within binomial family. The default link function is the logit function, which models the log-odds of success. Other available link functions include:
\itemize{
\item "probit" for the probit link function, which models the cumulative standard normal distribution.
\item "cloglog" for the complementary log-log link function, which models the complementary log-log of the survival function.
}

It is important to choose the appropriate \code{link} function based on the specific characteristics and assumptions of your binary data. The default "binomial" family with the logit link function is often a good starting point, but alternative link functions might be more appropriate depending on the research question and the nature of the data.
See also the function 'emBinRegMAR' function.
}
\examples{
\donttest{
data(sixcitydata)
f_fit <- emforbeta(Wheeze~city+soc+cond,
                   data=sixcitydata,
                   vcorctn= TRUE,
                   family=binomial(link="logit"),
                   method="glm.fit")
summary(f_fit$mfit) #creates the summary like glm using the return object mfit
vcov_beta<-f_fit$cvcov #creates variance using Louis (1982)

# Computes the standard error of the estimates
se_beta_em<-sqrt(diag(vcov_beta))
se_beta_em

# Firth correction
f_fit <- emforbeta(Wheeze~city+soc+cond,
                   data=sixcitydata,
                   family=binomial(link="logit"),
                   method="brglmFit")
# creates the summary like glm using the return object mfit

data(ibrahim)
f_fit2 <- emforbeta(y~x1+x2+x3,
                    data=ibrahim,
                    family="binomial")
summary(f_fit2$mfit) #creates the summary like glm using the return object mfit

f_fit2 <- emforbeta(y~x1+x2+x3,
                    data=ibrahim,
                    family=binomial (link="probit"),
                    method="brglmFit")
# creates the summary like glm using the return object mfit
summary(f_fit2$mfit) #

data(est)
f_fit <- emforbeta(survive~Fetoprtn+Antigen+Jaundice+Age,
                   data=est,
                   family=binomial,
                   method="glm.fit")
summary(f_fit$mfit)

f_fit <- emforbeta(survive~Fetoprtn+Antigen+Jaundice+Age,
                   data=est,
                   family=binomial,
                   method="brglmFit")
# Firth corrected estimates with out Louis (1982) correction (see Maiti and Pradhan (2009))
summary(f_fit$mfit)

data(metastmelanoma)
f_fit <- emforbeta(failcens~size+type+nodal+age+sex+trt,
                   data=metastmelanoma,
                   family=binomial,
                   method="glm.fit")
summary(f_fit$mfit)

f_fit <- emforbeta(failcens~size+type+nodal+age+sex+trt,
                   data=metastmelanoma,
                   family=binomial,
                   method="brglmFit")
# Firth corrected estimates with out Louis (1982) correction (see Maiti and Pradhan (2009))
summary(f_fit$mfit)

data(felinedata)
f_fit <- emforbeta(chlamy~Season+Agegrp+Conj+FHV1,
                   data=felinedata,
                   family=binomial,
                   method="glm.fit")
summary(f_fit$mfit)

f_fit <- emforbeta(chlamy~Season+Agegrp+Conj+FHV1,
                   data=felinedata,
                   family=binomial,
                   method="brglmFit")
# Firth corrected estimates with out Louis (1982) correction
summary(f_fit$mfit)
}

}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Louis, T. A. (1982). Finding the observed information when using the EM algorithm. Proceedings of the Royal Statistical Society, Ser B, 44, 226-233.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
}
