% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{lookup_commit}
\alias{lookup_commit}
\alias{lookup_commit.git_branch}
\alias{lookup_commit.git_commit}
\alias{lookup_commit.git_tag}
\alias{lookup_commit.git_reference}
\title{Lookup the commit related to a git object}
\usage{
lookup_commit(object)

\method{lookup_commit}{git_branch}(object)

\method{lookup_commit}{git_commit}(object)

\method{lookup_commit}{git_tag}(object)

\method{lookup_commit}{git_reference}(object)
}
\arguments{
\item{object}{a git object to get the related commit from.}
}
\value{
A git commit object.
}
\description{
Lookup the commit related to a git_reference, git_tag or
git_branch object.
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Create a file, add and commit
lines <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
writeLines(lines, con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "Commit message 1")

## Get the commit pointed to by the 'master' branch
lookup_commit(repository_head(repo))

## Create a tag
a_tag <- tag(repo, "Tagname", "Tag message")

## Get the commit pointed to by 'a_tag'
lookup_commit(a_tag)
}
}
