% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_gradient_smooth.R
\name{geom_gradient_smooth}
\alias{geom_gradient_smooth}
\alias{stat_gradient_smooth}
\title{Create a Gradient Smoothed Field Layer}
\usage{
geom_gradient_smooth(
  mapping = NULL,
  data = NULL,
  stat = StatStreamField,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  formula = z ~ x + y + I(x^2) + I(y^2),
  xlim = NULL,
  ylim = NULL,
  n = 11,
  max_it = 1000,
  T = NULL,
  L = NULL,
  center = TRUE,
  type = "vector",
  normalize = TRUE,
  tail_point = FALSE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 30, length = grid::unit(0.02, "npc"), type = "closed")
)

stat_gradient_smooth(
  mapping = NULL,
  data = NULL,
  geom = GeomStream,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  formula = z ~ x + y + I(x^2) + I(y^2),
  xlim = NULL,
  ylim = NULL,
  n = 11,
  max_it = 1000,
  T = NULL,
  L = NULL,
  center = TRUE,
  type = "vector",
  normalize = TRUE,
  tail_point = FALSE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 30, length = grid::unit(0.02, "npc"), type = "closed")
)
}
\arguments{
\item{mapping}{A set of aesthetic mappings created by \code{ggplot2::aes()}.
\strong{Required:} Must include \strong{\code{x}} and \strong{\code{y}}; vector displacements are defined
by \strong{\code{fx}} and \strong{\code{fy}}.}

\item{data}{A data frame containing the raw vector data.}

\item{stat}{The statistical transformation to use on the data. Defaults to
\code{"vector_smooth"}.}

\item{position}{Position adjustment, either as a string or the result of a
position adjustment function.}

\item{...}{Additional arguments passed to the layer.}

\item{na.rm}{Logical. If \code{FALSE} (the default), missing values are removed
with a warning.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{inherit.aes}{Logical. If \code{FALSE}, overrides the default aesthetics
rather than combining with them.}

\item{formula}{A formula specifying the linear model for the scalar field.
Defaults to \code{z ~ x + y + I(x^2) + I(y^2)}.}

\item{xlim}{Numeric vector of length 2 specifying the domain limits in the
\eqn{x}-direction. Defaults to \eqn{c(-1, 1)}.}

\item{ylim}{Numeric vector of length 2 specifying the domain limits in the
\eqn{y}-direction. Defaults to \eqn{c(-1, 1)}.}

\item{n}{An integer vector specifying the grid resolution for smoothing.}

\item{max_it}{Maximum number of iterations for field integration (when used in streamlines).}

\item{T}{If \code{normalize = FALSE}, this controls the time length for growing streams.}

\item{L}{If \code{normalize = TRUE}, this controls the fixed length of streams or vectors.}

\item{center}{Logical. If \code{TRUE}, the vector is recentered so that the
original \verb{(x, y)} becomes the midpoint (default is \code{TRUE} for
\code{geom_vector()} and \code{FALSE} for \code{geom_vector2()}).}

\item{type}{Character. Either \code{"stream"} (default) or \code{"vector"}. \code{"stream"}
computes a full streamline by integrating in both directions (if \code{center = TRUE}), while \code{"vector"} computes a single vector.}

\item{normalize}{Logical. If \code{TRUE}, the vector endpoints are scaled to unit
length before being scaled by \code{L} (default: \code{TRUE}).}

\item{tail_point}{Logical. If \code{TRUE}, draws the tail point of vectors/streams (default: \code{FALSE}).}

\item{eval_point}{Logical. If \code{TRUE}, marks the evaluation points used to fit gradients.}

\item{grid}{A user-supplied data frame or pattern (e.g., "hex") for specifying custom evaluation points.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{arrow}{An optional \code{grid::arrow()} specification to add arrowheads to
the vectors (default: \code{grid::arrow(angle = 25, length = unit(0.025, "npc"), type = "closed")}).}

\item{geom}{The geometric object used to render the streamline (only used in
\code{stat_stream()}; defaults to \link{GeomStream}).}
}
\value{
A ggplot2 layer that can be added to a ggplot object.
}
\description{
\code{geom_gradient_smooth()} creates a ggplot2 layer that visualizes the gradient
of a scalar field computed from raw data. A linear model is fitted using the
supplied \code{formula} (default: \code{z ~ x + y + I(x^2) + I(y^2)}) on the raw data,
and the numerical gradient is computed using numDeriv::grad(). The computed
gradient field is then visualized using \code{\link[=GeomStream]{GeomStream()}}.
}
\section{Aesthetics}{

\code{geom_gradient_smooth()} supports the following aesthetics (required aesthetics are in \strong{bold}):
\itemize{
\item \strong{\code{x}}: The x-coordinate of the data point.
\item \strong{\code{y}}: The y-coordinate of the data point.
\item \strong{\code{z}}: The scalar value used for computing the gradient.
\item \code{color}: The color used for the gradient vectors. Defaults depend on the
selected \code{type}.
}
}

\section{Details}{

\strong{Gradient Calculation:}
A linear model is fitted using the provided \code{formula} and the raw data. The scalar
field defined by the model is then differentiated numerically with
\code{numDeriv::grad()} to yield gradient vectors.

\strong{Visualization:}
The resulting gradient field is visualized using \code{\link[=GeomStream]{GeomStream()}}. Since \code{z} is only
used internally, it is dropped from the final visual output.
}

\examples{
\donttest{
# Define several scalar field functions:

# Example 1: f(x, y) = x^2 - y^2
f <- function(u) {
  x <- u[1]
  y <- u[2]
  x^2 - y^2
}

# Example 2: g(x, y) = sin(x) * cos(y)
g <- function(u) {
  x <- u[1]
  y <- u[2]
  sin(x) * cos(y)
}

# Example 3: h(x, y) = log(|x| + 1) + sqrt(|y|)
h <- function(u) {
  x <- u[1]
  y <- u[2]
  log(abs(x) + 1) + sqrt(abs(y))
}

# Create a grid of evaluation points
grid_data <- expand.grid(
  x = seq(-5, 5, length.out = 30),
  y = seq(-5, 5, length.out = 30)
)

# Compute the scalar field for f and plot its gradient
grid_data$z <- apply(grid_data, 1, f)

ggplot(grid_data, aes(x = x, y = y, z = z)) +
  geom_gradient_smooth()

# Compute and plot for g:
grid_data$z <- apply(grid_data, 1, g)
ggplot(grid_data, aes(x = x, y = y, z = z)) +
  geom_gradient_smooth()

# Compute and plot for h:
grid_data$z <- apply(grid_data, 1, h)
ggplot(grid_data, aes(x = x, y = y, z = z)) +
  geom_gradient_smooth()
}
}
