% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-star.R
\name{geom_star}
\alias{geom_star}
\title{Star layer}
\usage{
geom_star(
  mapping = NULL,
  data = NULL,
  na.rm = FALSE,
  stat = "identity",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{na.rm}{If `FALSE`, the default, missing values are removed with
a warning. If `TRUE`, missing values are silently removed.}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{layer}}.}
}
\value{
polygonal point layer
}
\description{
geom_star provides the multiple geometric shape to create scatter plot or 
other point plot, it is like the 'geom_point' of 'ggplot2'.
Note: the 'left-triangle' (17, 19) and 'right-triangle' (18, 20) are 
developed to plot the 'triangle-heatmap'. Their centers are not in their internal,
but the center of hypotenuse.
}
\details{
Aesthetics \code{geom_star} understands the following aesthetics. Required
aesthetics are displayed in bold and defaults are displayed for optional aesthetics:
 \itemize{
    \item \strong{\code{x}}.
    \item \strong{\code{y}}.
    \item \code{starshape} the shape of point, default is 1 (star shape).
    \item \code{starstroke} control the thickness of margin of point, default is 0.5.
    \item \code{size} the size of point, default is 1.5.
    \item \code{colour} the colour of margin, default is 'black'.
    \item \code{fill} the colour of fill, default is NA.
    \item \code{alpha} the transparency of fill, default is 1.
    \item \code{angle} control the angle of rotation of point, default is 0.
    \item \code{subset} subset the data frame which meet conditions to display.
 }
}
\examples{
library(ggplot2)
p <- ggplot(iris, aes(x=Sepal.Length, 
                      y=Sepal.Width, 
                      starshape=Species)) + 
     geom_star(size=4)
p
}
\author{
Shuangbin Xu
}
