% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_edge_density.R
\name{geom_edge_density}
\alias{geom_edge_density}
\title{Show edges as a density map}
\usage{
geom_edge_density(
  mapping = NULL,
  data = get_edges("short"),
  position = "identity",
  show.legend = NA,
  n = 100,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x, y, xend, yend, group and
circular are mapped to x, y, xend, yend, edge.id and circular in the edge
data.}

\item{data}{The return of a call to \code{get_edges()} or a data.frame
giving edges in correct format (see details for for guidance on the format).
See \code{\link[=get_edges]{get_edges()}} for more details on edge extraction.}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{n}{The number of points to estimate in the x and y direction, i.e. the
resolution of the raster.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}
}
\description{
This geom makes it possible to add a layer showing edge presence as a density
map. Each edge is converted to \code{n} points along the line and a jitter is
applied. Based on this dataset a two-dimensional kernel density estimation is
applied and plotted as a raster image. The density is mapped to the alpha
level, making it possible to map a variable to the fill.
}
\section{Aesthetics}{

\code{geom_edge_density} understand the following aesthetics. Bold aesthetics are
automatically set, but can be overwritten.

\strong{x}
\strong{y}
\strong{xend}
\strong{yend}
edge_fill
filter
}

\section{Computed variables}{


\describe{
\item{x, y}{The coordinates for each pixel in the raster}
\item{density}{The density associated with the pixel}
}
}

\section{Edge aesthetic name expansion}{

In order to avoid excessive typing edge aesthetic names are
automatically expanded. Because of this it is not necessary to write
\code{edge_colour} within the \code{aes()} call as \code{colour} will
automatically be renamed appropriately.
}

\examples{
require(tidygraph)
gr <- create_notable('bull') \%>\%
  activate(edges) \%>\%
  mutate(class = sample(letters[1:3], n(), replace = TRUE))

ggraph(gr, 'stress') +
  geom_edge_density(aes(fill = class)) +
  geom_edge_link() + geom_node_point()
}
\seealso{
Other geom_edge_*: 
\code{\link{geom_edge_arc}()},
\code{\link{geom_edge_bend}()},
\code{\link{geom_edge_bundle_force}()},
\code{\link{geom_edge_bundle_minimal}()},
\code{\link{geom_edge_bundle_path}()},
\code{\link{geom_edge_diagonal}()},
\code{\link{geom_edge_elbow}()},
\code{\link{geom_edge_fan}()},
\code{\link{geom_edge_hive}()},
\code{\link{geom_edge_link}()},
\code{\link{geom_edge_loop}()},
\code{\link{geom_edge_parallel}()},
\code{\link{geom_edge_point}()},
\code{\link{geom_edge_sf}()},
\code{\link{geom_edge_span}()},
\code{\link{geom_edge_tile}()}
}
\author{
Thomas Lin Pedersen
}
\concept{geom_edge_*}
