% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_means.R
\name{compare_means}
\alias{compare_means}
\title{Comparison of Means}
\usage{
compare_means(
  formula,
  data,
  method = "wilcox.test",
  paired = FALSE,
  group.by = NULL,
  ref.group = NULL,
  symnum.args = list(),
  p.adjust.method = "holm",
  ...
)
}
\arguments{
\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
 numeric variable giving the data values and \code{group} is a factor with
 one or multiple levels giving the corresponding groups. For example,
 \code{formula = TP53 ~ cancer_group}.

 It's also possible to perform the test for multiple response variables at
 the same time. For example, \code{formula = c(TP53, PTEN) ~ cancer_group}.}

\item{data}{a data.frame containing the variables in the formula.}

\item{method}{the type of test. Default is \link[stats]{wilcox.test}. Allowed
values include: \itemize{ \item \code{\link[stats]{t.test}} (parametric) and
\code{\link[stats]{wilcox.test}} (non-parametric). Perform comparison
between two groups of samples. If the grouping variable contains more than
two levels, then a pairwise comparison is performed. \item
\code{\link[stats]{anova}} (parametric) and
\code{\link[stats]{kruskal.test}} (non-parametric). Perform one-way ANOVA
test comparing multiple groups. }}

\item{paired}{a logical indicating whether you want a paired test. Used only
in \code{\link[stats]{t.test}} and in \link[stats]{wilcox.test}.}

\item{group.by}{a character vector containing the name of grouping variables.}

\item{ref.group}{a character string specifying the reference group. If
 specified, for a given grouping variable, each of the group levels will be
 compared to the reference group (i.e. control group).

 \code{ref.group} can be also \code{".all."}. In this case, each of the
 grouping variable levels is compared to all (i.e. basemean).}

\item{symnum.args}{a list of arguments to pass to the function
 \code{\link[stats]{symnum}} for symbolic number coding of p-values. For
 example, \code{symnum.args <- list(cutpoints = c(0, 0.0001, 0.001,
 0.01, 0.05, Inf), symbols = c("****", "***", "**", "*",  "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001 \item \code{****}:  p <= 0.0001 }}

\item{p.adjust.method}{method for adjusting p values (see
 \code{\link[stats]{p.adjust}}). Has impact only in a situation, where
 multiple pairwise tests are performed; or when there are multiple grouping
 variables. Allowed values include "holm", "hochberg", "hommel",
 "bonferroni", "BH", "BY", "fdr", "none". If you don't want to adjust the p
 value (not recommended), use p.adjust.method = "none".

 Note that, when the \code{formula} contains multiple variables, the p-value
 adjustment is done independently for each variable.}

\item{...}{Other arguments to be passed to the test function.}
}
\value{
return a data frame with the following columns:
\itemize{
\item \code{.y.}: the y variable used in the test.
\item \code{group1,group2}: the compared groups in the pairwise tests.
Available only when \code{method = "t.test"} or \code{method = "wilcox.test"}.
\item \code{p}: the p-value.
\item \code{p.adj}: the adjusted p-value. Default for \code{p.adjust.method = "holm"}.
\item \code{p.format}: the formatted p-value.
\item \code{p.signif}: the significance level.
\item \code{method}: the statistical test used to compare groups.


}
}
\description{
Performs one or multiple mean comparisons.
}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth

# One-sample test
#:::::::::::::::::::::::::::::::::::::::::
compare_means(len ~ 1, df, mu = 0)

# Two-samples unpaired test
#:::::::::::::::::::::::::::::::::::::::::
compare_means(len ~ supp, df)

# Two-samples paired test
#:::::::::::::::::::::::::::::::::::::::::
compare_means(len ~ supp, df, paired = TRUE)

# Compare supp levels after grouping the data by "dose"
#::::::::::::::::::::::::::::::::::::::::
compare_means(len ~ supp, df, group.by = "dose")

# pairwise comparisons
#::::::::::::::::::::::::::::::::::::::::
# As dose contains more thant two levels ==>
# pairwise test is automatically performed.
compare_means(len ~ dose, df)

# Comparison against reference group
#::::::::::::::::::::::::::::::::::::::::
compare_means(len ~ dose, df, ref.group = "0.5")

# Comparison against all
#::::::::::::::::::::::::::::::::::::::::
compare_means(len ~ dose, df, ref.group = ".all.")

# Anova and kruskal.test
#::::::::::::::::::::::::::::::::::::::::
compare_means(len ~ dose, df, method = "anova")
compare_means(len ~ dose, df, method = "kruskal.test")
}
