context("ttheme constructors")

test_that("alpha FF is applied by default", {
  ttheme.ls <- ttheme_gtdefault()
  expect_type(ttheme.ls, "list")
  expect_equal(ttheme.ls$core$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$core$bg_params$col, "#FFFFFFFF")
  expect_equal(ttheme.ls$core$bg_params$fill, c("#F2F2F2", "#E5E5E5"))
  expect_equal(ttheme.ls$colhead$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$colhead$bg_params$col, "#FFFFFFFF")
  expect_equal(ttheme.ls$colhead$bg_params$fill, "#CCCCCCFF")
  expect_equal(ttheme.ls$rowhead$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$rowhead$bg_params$col, "#FFFFFFFF")
  expect_equal(ttheme.ls$rowhead$bg_params$fill, "#CCCCCCFF")
})

test_that("text.alpha 0.25 is applied as argument", {
  ttheme.ls <- ttheme_gtdefault(text.alpha = 0.25)
  expect_type(ttheme.ls, "list")
  expect_equal(ttheme.ls$core$fg_params$col, "#00000040")
  expect_equal(ttheme.ls$core$bg_params$col, "#FFFFFFFF")
  expect_equal(ttheme.ls$core$bg_params$fill, c("#F2F2F2", "#E5E5E5"))
  expect_equal(ttheme.ls$colhead$fg_params$col, "#00000040")
  expect_equal(ttheme.ls$colhead$bg_params$col, "#FFFFFFFF")
  expect_equal(ttheme.ls$colhead$bg_params$fill, "#CCCCCCFF")
  expect_equal(ttheme.ls$rowhead$fg_params$col, "#00000040")
  expect_equal(ttheme.ls$rowhead$bg_params$col, "#FFFFFFFF")
  expect_equal(ttheme.ls$rowhead$bg_params$fill, "#CCCCCCFF")
})

test_that("rules.alpha 0.25 is applied as argument", {
  ttheme.ls <- ttheme_gtdefault(rules.alpha = 0.25)
  expect_type(ttheme.ls, "list")
  expect_equal(ttheme.ls$core$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$core$bg_params$col, "#FFFFFF40")
  expect_equal(ttheme.ls$core$bg_params$fill, c("#F2F2F2", "#E5E5E5"))
  expect_equal(ttheme.ls$colhead$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$colhead$bg_params$col, "#FFFFFF40")
  expect_equal(ttheme.ls$colhead$bg_params$fill, "#CCCCCCFF")
  expect_equal(ttheme.ls$rowhead$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$rowhead$bg_params$col, "#FFFFFF40")
  expect_equal(ttheme.ls$rowhead$bg_params$fill, "#CCCCCCFF")
})

test_that("canvas.alpha 0.25 is applied as argument", {
  ttheme.ls <- ttheme_gtdefault(rules.alpha = 0.25)
  expect_type(ttheme.ls, "list")
  expect_equal(ttheme.ls$core$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$core$bg_params$col, "#FFFFFF40")
  expect_equal(ttheme.ls$core$bg_params$fill, c("#F2F2F2", "#E5E5E5"))
  expect_equal(ttheme.ls$colhead$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$colhead$bg_params$col, "#FFFFFF40")
  expect_equal(ttheme.ls$colhead$bg_params$fill, "#CCCCCCFF")
  expect_equal(ttheme.ls$rowhead$fg_params$col, "#000000FF")
  expect_equal(ttheme.ls$rowhead$bg_params$col, "#FFFFFF40")
  expect_equal(ttheme.ls$rowhead$bg_params$fill, "#CCCCCCFF")
})
