% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-shape.R
\name{scale_pattern_shape}
\alias{scale_pattern_shape}
\alias{scale_pattern_shape_discrete}
\alias{scale_pattern_shape_ordinal}
\alias{scale_pattern_shape_continuous}
\title{Scales for shapes, aka glyphs}
\usage{
scale_pattern_shape(..., solid = TRUE)

scale_pattern_shape_discrete(..., solid = TRUE)

scale_pattern_shape_ordinal(...)

scale_pattern_shape_continuous(...)
}
\arguments{
\item{...}{other arguments passed to discrete_scale()}

\item{solid}{Should the shapes be solid, \code{TRUE}, or hollow,
\code{FALSE}?}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
\code{scale_pattern_shape} maps discrete variables to six easily discernible shapes.
If you have more than six levels, you will get a warning message, and the
seventh and subsequence levels will not appear on the plot. Use
\code{\link[=scale_pattern_shape_manual]{scale_pattern_shape_manual()}} to supply your own values. You can not map
a continuous variable to shape unless \code{scale_pattern_shape_binned()} is used. Still,
as shape has no inherent order, this use is not advised..
}
\details{
Scales for area or radius
}
\examples{
  if (require("ggplot2")) {
    # 'pch' pattern example
    gg <- ggplot(mtcars, aes(as.factor(cyl), mpg)) +
      geom_violin_pattern(aes(fill = as.factor(cyl),
                              pattern_shape = as.factor(cyl)),
        pattern = 'pch',
        pattern_density = 0.3,
        pattern_angle = 0,
        colour  = 'black'
      ) +
      theme_bw(18) +
      theme(legend.position = 'none') +
      scale_pattern_shape() +
      labs(
        title    = "ggpattern::geom_violin_pattern()",
        subtitle = "pattern = 'pch'"
      )
    plot(gg)
  }

}
