% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset_shape_rectangle.R
\name{shape_rectangle}
\alias{shape_rectangle}
\title{Rectangular insets}
\usage{
shape_rectangle(centre, hwidth, hheight = NULL)
}
\arguments{
\item{centre}{Coordinates of the inset centre. Ideally this should be an
\code{sfc} object (see \code{\link[sf:sfc]{sf::st_sfc()}}) including a coordinate reference system.
An \code{\link[sf:st]{sf::st_point()}} or a vector of longitude and latitude are also accepted.
If a CRS cannot be determined, WGS 84 is assumed.}

\item{hwidth}{Half width of the inset in the units of the inset's \code{crs_working}.}

\item{hheight}{Half height of the inset in the units of the inset's \code{crs_working}.
Defaults to the same value as \code{hwidth}.}
}
\value{
A shape definition suitable for use with \code{\link[=configure_inset]{configure_inset()}}.
}
\description{
Rectangular insets
}
\examples{
library(ggplot2)
nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
make_demo <- function(...) {
  ggplot(nc) +
    geom_sf(fill = "grey95", colour = "grey85") +
    # For a filled frame, we want to interleave it between the base layer
    # (above this line) and the target layer (below the following line).
    geom_inset_frame(target.aes = list(fill = "white")) +
    geom_sf_inset(map_base = "none") +
    coord_sf_inset(inset = configure_inset(...)) +
    theme_void()
}
rectangle <- shape_rectangle(sf::st_centroid(nc[21,]), hwidth = 50, hheight = 40)

make_demo(rectangle, scale = 3, translation = c(-300, 0))
make_demo(rectangle, scale = 3, translation = c(-250, -200))
make_demo(rectangle, scale = 3, translation = c(-150, -100))
make_demo(rectangle, scale = 3, translation = c(0, 0))
make_demo(rectangle, scale = 0.5, translation = c(0, 0))
}
\seealso{
\code{\link[=configure_inset]{configure_inset()}}

Other shapes: 
\code{\link{shape_circle}()},
\code{\link{shape_sf}()}
}
\concept{shapes}
