% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwalpha.R
\name{gwalpha}
\alias{gwalpha}
\title{Geographically Weighted Cronbach's Alpha}
\usage{
gwalpha(
  x,
  data,
  kernel = "bisquare",
  adaptive = TRUE,
  bw,
  ci = FALSE,
  p = 0.95,
  nsims = 1000
)
}
\arguments{
\item{x}{a character vector or numeric vector with the column names or indices
of items in \code{data}}

\item{data}{a SpatialPointsDataFrame as defined in package \code{sp}, or a sf object
defined in package \code{sf}}

\item{kernel}{type of kernel function used to weight responses. Available
options: \code{"bisquare"} (default), \code{"gaussian"}, \code{"exponential"},
or \code{"boxcar"}}

\item{adaptive}{logical; if \code{TRUE} (default), the bandwidth \code{bw}
corresponds to the number of nearest neighbours; if \code{FALSE},
\code{bw} is a fixed distance}

\item{bw}{bandwidth for weighting function, can be specified or obtained using
\code{\link[=bw_gwalpha]{bw_gwalpha()}}}

\item{ci}{logical; if \code{TRUE}, bootstrapped confidence intervals are
computed}

\item{p}{the percentile for the upper confidence interval if \code{ci = TRUE}}

\item{nsims}{number of bootstrap iterations if \code{ci = TRUE}}
}
\value{
a data frame with:
\item{\code{gwalpha}}{local estimates of reliability}
\item{\code{gwalpha_u}}{upper confidence interval if \code{ci = TRUE}}
\item{\code{coords}}{coordinates matrix for each responses}
}
\description{
This function computes geographically weighted cronbach's alpha (GWalpha)
for responses from georeferenced multi-item survey scales.
}
\examples{
data(bes2011)
alpha100 <- gwalpha(
  x = c("willHelp", "closeKnit", "trust", "solComProb", "relGroups"),
  data = bes2011,
  bw = 100
  )

}
\references{
Zhang, S., and Z. Li. 2025. “ Geographically Weighted Cronbach's
Alpha (GWalpha): An Exploratory Local Measure of Reliability for Scale Construction.”
Geographical Analysis 57, no. 4: 758–772.
}
\seealso{
\code{\link[=bw_gwalpha]{bw_gwalpha()}}
}
