% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{Geocode Finnish Place Names or Street Addresses}
\usage{
geocode(
  search_string,
  source = "interpolated-road-addresses",
  crs = 3067,
  lang = "fi",
  size = NULL,
  options = NULL,
  api_key = getOption("geofi_mml_api_key")
)
}
\arguments{
\item{search_string}{Character. The place name or street address to geocode
(e.g., \code{"Suomenlinna"} or \code{"Mannerheimintie 100, Helsinki"}).}

\item{source}{Character. The data source to search in. Must be one of:
\code{"interpolated-road-addresses"} (default), \code{"geographic-names"},
\code{"addresses"}, \code{"mapsheets-tm35"}, or \code{"cadastral-units"}.}

\item{crs}{Character. The coordinate reference system (CRS) for the
output data, specified as an EPSG code. Must be one of \code{"EPSG:3067"}
(ETRS-TM35FIN, default) or \code{"EPSG:4326"} (WGS84).}

\item{lang}{Character. The language for the API response labels. Must be one of
\code{"fi"} (Finnish, default), \code{"sv"} (Swedish), or \code{"en"} (English).}

\item{size}{Numeric or NULL. The maximum number of results to return. Must be a
positive integer. If \code{NULL} (default), the API’s default size is used.}

\item{options}{Character or NULL. Additional options to pass to the API, specified
as a single string (e.g., \code{"focus.point.lat=60.1699&focus.point.lon=24.9384"}).
If \code{NULL} (default), no additional options are included. See the NLS
geocoding API documentation for valid options.}

\item{api_key}{Character. API key for authenticating with the NLS geocoding API.
Defaults to the value stored in \code{options(geofi_mml_api_key)}. You can
obtain an API key from the National Land Survey of Finland website (see
\url{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje}).}
}
\value{
An \code{sf} object containing the geocoded locations as points in the
specified \code{crs}. If no results are found, a warning is issued, and
an empty \code{sf} object is returned.
}
\description{
Geocodes Finnish place names or street addresses using the National Land Survey
of Finland (NLS) geocoding REST API. This function converts textual location
descriptions into spatial coordinates.
}
\details{
This function uses the NLS geocoding REST API to convert place names or street
addresses into spatial coordinates. It supports multiple data sources, including
interpolated road addresses, geographic names, and cadastral units. The function
includes robust error handling:
\itemize{
\item Retries failed requests up to 3 times for transient network issues.
\item Handles HTTP errors and rate limits (HTTP 429).
\item Validates inputs to prevent common errors.
}
}
\examples{
\dontrun{
# Set your API key
options(geofi_mml_api_key = "your_api_key_here")

# Geocode a place name
locations <- geocode(search_string = "Suomenlinna", source = "geographic-names")
print(locations)

# Geocode a street address with a custom size and output CRS
addresses <- geocode(
  search_string = "Mannerheimintie 100, Helsinki",
  source = "addresses",
  crs = "EPSG:4326",
  size = 5
)
print(addresses)
}

}
\seealso{
\code{\link{geocode_reverse}} for reverse geocoding.
\url{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje} for
instructions on obtaining an API key.
\url{https://www.maanmittauslaitos.fi/kartat-ja-paikkatieto/aineistot-ja-rajapinnat/paikkatietojen-rajapintapalvelut/geokoodauspalvelu}
for more information on the NLS geocoding API.
}
\author{
Markus Kainu \email{markus.kainu@kapsi.fi}
}
