library(testthat)

test_that("rss.z.test works as expected",{
  set.seed(123)
  rss.data=rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)
  result=rss.z.test(data1=rss.data, data2=NULL, alpha=0.05,alternative="two.sided", mu0=0)
  expect_equal(result$RSS_mean, 0.0907, tolerance = 1e-3)
  expect_equal(result$z, 0.570, tolerance = 1e-3)
  expect_equal(result$p.value, 0.569, tolerance = 1e-3)
  expect_equal(result$CI, c(-0.221,0.403), tolerance = 1e-3)

  set.seed(123)
  rss.data2<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)
  result=rss.z.test(data1=rss.data, data2=rss.data2, alpha=0.05, alternative="two.sided", mu0=0)
  expect_equal(result$RSS_mean, c(0.09074,-0.05269), tolerance = 1e-3)
  expect_equal(result$z, 0.666, tolerance = 1e-3)
  expect_equal(result$p.value, 0.505, tolerance = 1e-3)
  expect_equal(result$CI, c(-0.2785,0.5654), tolerance = 1e-3)


})

test_that("rss.z.test handles wrong input with error",{
  rss.data=rss.simulation(H=3,nsamp=c(6,7,8),dist="normal", rho=0.8,delta=0)
  rss.data2<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)
  expect_error(rss.z.test(data1=rss.data, data2=NULL, alpha=1.1,alternative="two.sided", mu0=0),
               "alpha is out of bound.")
  expect_error(rss.z.test(data1=rss.data, data2=NULL, alpha=0.05,alternative="one-sided", mu0=0),
               "Invalid alternative selected. Please choose from 'two.sided', 'less', or 'greater'.")
  expect_error(rss.z.test(data1=rss.data[,1], data2=NULL, alpha=0.05,alternative="two.sided", mu0=0),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.z.test(data1=rss.data[,2], data2=NULL, alpha=0.05,alternative="two.sided", mu0=0),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.z.test(data1=rss.data, data2=rss.data2, alpha=0,alternative="two.sided", mu0=0),
               "alpha is out of bound.")
  expect_error(rss.z.test(data1=rss.data, data2=rss.data2, alpha=0.05,alternative="one-sided", mu0=0),
               "Invalid alternative selected. Please choose from 'two.sided', 'less', or 'greater'.")
  expect_error(rss.z.test(data1=rss.data[,1], data2=rss.data2, alpha=0.05,alternative="two.sided", mu0=0),
               "The first input data must contain 'rank' and 'y' variables.")
  expect_error(rss.z.test(data1=rss.data[,2], data2=rss.data2, alpha=0.05,alternative="two.sided", mu0=0),
               "The first input data must contain 'rank' and 'y' variables.")
  expect_error(rss.z.test(data1=rss.data, data2=rss.data2[,1], alpha=0.05,alternative="two.sided", mu0=0),
               "The second input data must contain 'rank' and 'y' variables.")
  expect_error(rss.z.test(data1=rss.data, data2=rss.data2[,2], alpha=0.05,alternative="two.sided", mu0=0),
               "The second input data must contain 'rank' and 'y' variables.")
})
