% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.t.test.R
\name{rss.t.test}
\alias{rss.t.test}
\title{RSS t-test for one-sample and two-sample problems}
\usage{
rss.t.test(
  data1,
  data2 = NULL,
  alpha = 0.05,
  alternative = "two.sided",
  mu0 = 0,
  method
)
}
\arguments{
\item{data1}{A numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{data2}{An optional numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{alpha}{A numeric value specifying the confidence level for the interval.}

\item{alternative}{A character string specifying the alternative hypothesis. Must be one of "two.sided" (default), "greater", or "less".}

\item{mu0}{A numeric value indicating the hypothesized value of the mean (for a one-sample problem) or the mean difference (for a two-sample problem).}

\item{method}{A character string specifying the method used to approximate the t-distribution. Must be either "sample" or "naive".}
}
\value{
\item{RSS_mean}{The RSS mean estimate (for a one-sample problem) or a vector of RSS mean estimates for each group (for a two-sample problem).}
\item{CI}{The confidence interval for the population mean (for a one-sample problem) or for the mean difference (for a two-sample problem).}
\item{t}{The t-statistic for the test.}
\item{df}{The degrees of freedom for the test.}
\item{p.value}{The p-value for the test.}
}
\description{
The rss.t.test function performs one- and two-sample t-tests on ranked set sample data using t approximations, with methods described by Ahn et al. (2014).
}
\details{
This function performs a t-test on ranked set sample data for both one-sample and two-sample mean problems, using t approximations. For a one-sample test, provide \code{data1} as a data frame with \code{rank} and \code{y} columns. For a two-sample test, provide both \code{data1} and \code{data2} with equal set sizes. The \code{method} parameter allows for two options to approximate the t-distribution: "sample" and "naive" as introduced by Ahn et al. (2014). The function compute the t-statistic, confidence interval, degrees of freedom, and p-value based on the provided RSS data and specified parameters.
}
\examples{
## Balanced RSS with a set size 3 and equal sample sizes of 6 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data1=rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)

## one-sample t-test using 'naive' method
rss.t.test(data1=rss.data1, data2=NULL, alpha=0.05,
alternative="two.sided", mu0=0, method="naive")

## one-sample t-test using 'sample' method
rss.t.test(data1=rss.data1, data2=NULL, alpha=0.05,
alternative="two.sided", mu0=0, method="sample")

## Unbalanced RSS with a set size 3 and different sample sizes of 6, 10, and 8 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data2<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)

## two-sample t-test using 'naive' method
rss.t.test(data1=rss.data1, data2=rss.data2, alpha=0.05,
alternative="two.sided", mu0=0, method="naive")

## two-sample t-test using 'sample' method
rss.t.test(data1=rss.data1, data2=rss.data2, alpha=0.05,
alternative="two.sided", mu0=0, method="sample")
}
\references{
S. Ahn, J. Lim, and X. Wang. (2014) The student’s t approximation to distributions of pivotal statistics from ranked set samples. Journal of the Korean Statistical Society, 43, 643–652.
}
\seealso{
\code{\link{rss.simulation}}: used for simulating Ranked Set Samples (RSS), which can serve as input.

\code{\link{rss.sampling}}: used for sampling Ranked Set Samples (RSS) from a population data set, providing input data.
}
