% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseSNP_vcf.R
\name{summariseSNP_vcf}
\alias{summariseSNP_vcf}
\title{Distribution of SNPs Across Chromosomes from VCF}
\usage{
summariseSNP_vcf(vcf_data)
}
\arguments{
\item{vcf_data}{A \code{vcfR} object containing VCF data.}
}
\value{
A data frame with chromosome names and the count of SNPs for each chromosome.
}
\description{
Distribution of SNPs Across Chromosomes from VCF
}
\examples{
\donttest{
demo_SNP <- system.file("extdata", "demo_SNP.vcf", package = "geneNR")
vcf_data <- import_vcf(demo_SNP)
snp_distribution <- summariseSNP_vcf(vcf_data)
print(snp_distribution)
}
}
