% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_audio.R
\name{gemini_audio.vertex}
\alias{gemini_audio.vertex}
\title{Analyze Audio using Gemini Vertex API}
\usage{
gemini_audio.vertex(
  audio = NULL,
  prompt = "Describe this audio",
  tokens = NULL,
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234
)
}
\arguments{
\item{audio}{Path to the audio file (character string). only supports "mp3".}

\item{prompt}{A prompt to guide the Gemini API's analysis (character string, defaults to "Describe this audio").}

\item{tokens}{A list containing the API URL and key from token.vertex() function.}

\item{temperature}{The temperature to use. Default is 1 value should be between 0 and 2
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{maxOutputTokens}{The maximum number of tokens to generate.
Default is 8192 and 100 tokens correspond to roughly 60-80 words.}

\item{topK}{The top-k value to use. Default is 40 value should be between 0 and 100
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{topP}{The top-p value to use. Default is 0.95 value should be between 0 and 1
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{seed}{The seed to use. Default is 1234 value should be integer
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}
}
\value{
A character vector containing the Gemini API's description of the audio.
}
\description{
This function sends audio to the Gemini API and returns a text description.
}
