% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdm.partition.deviance.R
\name{gdm.partition.deviance}
\alias{gdm.partition.deviance}
\title{Perform Deviance Partitioning of a Fitted GDM}
\usage{
gdm.partition.deviance(sitePairTable, varSets=list(), partSpace=TRUE)
}
\arguments{
\item{sitePairTable}{A correctly formatted site-pair table from
\code{\link[gdm]{formatsitepair}}.}

\item{varSets}{A list in which each element is a vector of variable names
across which deviance partitioning is to be performed, excluding
geographic distance (which is set by the partSpace argument). Variable names
must match those used to build the site-pair table. See example.}

\item{partSpace}{Whether or not to perform the partitioning using
geographic space. Default=TRUE.}
}
\value{
A dataframe summarizing deviance partitioning results.
}
\description{
Partitions deviance explained from GDM into different
user specified components - most typically environment versus space.
}
\examples{
# set up site-pair table using the southwest data set
sppData <- southwest[, c(1,2,13,14)]
envTab <- southwest[, c(2:ncol(southwest))]
sitePairTab <- formatsitepair(sppData, 2, XColumn="Long", YColumn="Lat",
sppColumn="species", siteColumn="site", predData=envTab)

# EXAMPLE - Partition two groups of variables
# Make list of variable sets for partitioning
varSet <- vector("list", 2)

# now, name the variable groups for partitioning
# note you do not need to add "space" as this is only needed
# for environmental variables

# two groups (soils & climate)
names(varSet) <- c("soil", "climate")

# lastly, add variable names for
varSet$soil <- c("awcA", "phTotal", "sandA", "shcA", "solumDepth")
varSet$climate <- c("bio5", "bio6", "bio15", "bio18", "bio19")
varSet

# run the function to partition soils, climate, and space (partSpace=TRUE)
scgPart <- gdm.partition.deviance(sitePairTab, varSet, partSpace=TRUE)

# EXAMPLE - Partition three groups of variables
# Make list of variable sets for partitioning
varSet <- vector("list", 3)
names(varSet) <- c("soil", "temp", "precip")
varSet$soil <- c("awcA", "phTotal", "sandA", "shcA", "solumDepth")
varSet$temp <- c("bio5", "bio6")
varSet$precip <- c("bio15", "bio18", "bio19")

# partition soils, temperature, and precip
# note we can't also partition space given the function's limit to a
# maximum of three variable sets, so we set partSpace=FALSE
scPart <- gdm.partition.deviance(sitePairTab, varSet, partSpace=FALSE)

}
\author{
Matt Fitzpatrick and Karel Mokany
}
