% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_simulate.R
\name{gas_simulate}
\alias{gas_simulate}
\title{Simulate GAS Model}
\usage{
gas_simulate(
  gas_object = NULL,
  t_sim = 1L,
  x_sim = NULL,
  distr = NULL,
  param = NULL,
  scaling = "unit",
  regress = "joint",
  n = NULL,
  p = 1L,
  q = 1L,
  par_static = NULL,
  par_link = NULL,
  par_init = NULL,
  coef_est = NULL
)
}
\arguments{
\item{gas_object}{An optional GAS estimate, i.e. a list of S3 class \code{gas} returned by function \code{\link[gasmodel:gas]{gas()}}.}

\item{t_sim}{A number of observations to simulate.}

\item{x_sim}{Exogenous variables used for simulations. For a single variable common for all time-varying parameters, a numeric vector. For multiple variables common for all time-varying parameters, a numeric matrix with observations in rows. For individual variables for each time-varying parameter, a list of numeric vectors or matrices in the above form. The number of observation must be equal to \code{t_sim}.}

\item{distr, param, scaling, regress, n, p, q, par_static, par_link, par_init, coef_est}{When \code{gas_object} is not supplied, the estimated model can be specified using these individual arguments. See the arguments and value of the \code{\link[gasmodel:gas]{gas()}} function for more details.}
}
\value{
A \code{list} of S3 class \code{gas_simulate} with components:
\item{data$x_sim}{The exogenous variables used in simulation.}
\item{model$distr}{The conditional distribution.}
\item{model$param}{The parametrization of the conditional distribution.}
\item{model$scaling}{The scaling function.}
\item{model$regress}{The specification of the regression and dynamic equation.}
\item{model$t_sim}{The length of the simulated time series.}
\item{model$n}{The dimension of the model.}
\item{model$m}{The number of exogenous variables.}
\item{model$p}{The score order.}
\item{model$q}{The autoregressive order.}
\item{model$par_static}{The static parameters.}
\item{model$par_link}{The parameters with the logarithmic/logistic links.}
\item{model$par_init}{The initial values of the time-varying parameters.}
\item{model$coef_est}{The estimated coefficients.}
\item{simulation$y_sim}{The simulated time series.}
\item{simulation$par_tv_sim}{The simulated time-varying parameters.}
\item{simulation$score_tv_sim}{The simulated scores.}
}
\description{
A function for simulation of generalized autoregressive score (GAS) models of Creal et al. (2013) and Harvey (2013).
Instead of supplying arguments about the model, the function can be applied to the \code{gas} object obtained by the \code{\link[gasmodel:gas]{gas()}} function.
}
\note{
Supported generic functions for S3 class \code{gas_simulate} include \code{\link[base:summary]{summary()}} ans \code{\link[base:plot]{plot()}}.
}
\examples{
\donttest{# Simulate GAS model based on the negative binomial distribution
sim_negbin <- gas_simulate(t_sim = 50, distr = "negbin", reg = "sep",
  coef_est = c(2.60, 0.02, 0.95, 0.03))
sim_negbin

# Plot the simulated time series
plot(sim_negbin)}

}
\references{
Creal, D., Koopman, S. J., and Lucas, A. (2013). Generalized Autoregressive Score Models with Applications. \emph{Journal of Applied Econometrics}, \strong{28}(5), 777–795. \doi{10.1002/jae.1279}.

Harvey, A. C. (2013). \emph{Dynamic Models for Volatility and Heavy Tails: With Applications to Financial and Economic Time Series}. Cambridge University Press. \doi{10.1017/cbo9781139540933}.
}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
}
