% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{gameR_cont}
\alias{gameR_cont}
\title{Generate continuous palette from a discrete gameR palette}
\usage{
gameR_cont(
  n,
  palette = NULL,
  reverse = FALSE,
  bias = NULL,
  interpolate = "spline"
)
}
\arguments{
\item{n}{Number of colors to be generated}

\item{palette}{Character name of palette. Either
banjo, blocks, border, cowboy, cups, cyberpunk, fallout, frisk, gris, human_rev, kirby, new_horizon, ocarina, okami, p3r, p4g, papyrus, pman, radio, rayman, sans, sonic, spirit, splat, superbros, wow}

\item{reverse}{Logical. Should the palette be reversed? Defaults to FALSE.}

\item{bias}{Passed to \link{colorRamp}. A positive number. Higher values
give more widely spaced colors at the high end.}

\item{interpolate}{Passed to \link{colorRamp}. Use spline or linear
interpolation}
}
\value{
Vector containing a hex color code representation for the chosen
palette interpolated across \code{n} values
}
\description{
Generate continuous palette from a discrete gameR palette
}
